if(window.innerWidth < 576) {
    var hammertime = new Hammer(document.body, {});
    hammertime.get('swipe').set({ direction: Hammer.DIRECTION_VERTICAL });
    var demoWrapper = document.querySelector(".demo-wrapper");
    function handleHeight(){
        demoWrapper.style.height = (window.innerHeight - 50) + "px";
        demoWrapper.querySelector(".container").style.height = (window.innerHeight - 86) + "px";
    }

    handleHeight();
    // hammertime.on("swipe", function(){
    //     handleHeight()
    // });

}


var eventLocked = false;
function lockEvent(){
    eventLocked = true;
    setTimeout(function(){
        eventLocked = false
    }, 300)
}
var desktopDemo = document.querySelector(".desktop-demo");
var mobileDemo = document.querySelector(".mobile-demo");

var onWheel = [];
var onViewChange = [];

// document.querySelector("header .logo img:first-of-type").src = "/img/header-logo-white.svg";

window.addEventListener('wheel', function(event)
{
    if(eventLocked) return;
    onWheel.forEach(function(fn){

        fn(event);
    });
});


function setListeners(parentEl){
    var featureSelects = parentEl.querySelectorAll(".pick-feature .feature");
    var previewFeatures = parentEl.querySelectorAll(".preview .feature");
    var previewPreviews = parentEl.querySelectorAll(".preview .feature .preview");
    var activeFeature = 0;
    var activePreview = 0;
    featureSelects[0].classList.add("active");

    function setDots(count){

        var picker = parentEl.querySelector(".preview-picker");
        picker.innerHTML = "";
        for(var i=0; i< count; i++){
            var el = document.createElement("div");
            picker.appendChild(el);
            el.addEventListener("click", pickPreview.bind(null, i), true);
        }
        picker.querySelector("div:first-of-type").classList.add("active")
    }


    function pickFeature(num){

        var thisElement =  parentEl.querySelector(".feature-"+ num);

        if(thisElement.classList.contains("active")) return;


        featureSelects.forEach(function(f){
            f.classList.remove("active");
        });
        parentEl.querySelector(".pick-feature div.feature[data-feature='"+num+"']").classList.add("active");


        previewFeatures.forEach(function(preview){
            preview.classList.remove("active")
        });

        activeFeature = num;
        thisElement.classList.add("active");


        setDots(parentEl.querySelectorAll(".feature-"+ num+" .preview").length);
        pickPreview(0);
    }

    function pickPreview(num){

        activePreview = num;
        previewPreviews.forEach(function(p){
            p.classList.remove("active");
        });
        parentEl.querySelectorAll(".preview-picker div").forEach(function(p){
            p.classList.remove("active");
        });

        parentEl.querySelector(".feature-"+activeFeature+" .preview-"+num).classList.add("active");
        parentEl.querySelector(".preview-picker div:nth-of-type("+(num+1)+")").classList.add("active");
    }

    function scrollDown(){

        var previewEl = parentEl.querySelector(".feature-"+activeFeature+" .preview-"+(activePreview+1));
        if(!previewEl) return;
        activePreview++;
        pickPreview(activePreview)
    }

    function scrollUp(){
        var previewEl = parentEl.querySelector(".feature-"+activeFeature+" .preview-"+(activePreview-1));
        if(!previewEl) return;
        activePreview--;
        pickPreview(activePreview)
    }


    pickFeature(0);

    featureSelects.forEach(function(el){
        el.addEventListener("click", function(){
            pickFeature(this.getAttribute("data-feature"));
        });
    });


    onWheel.push(function(event)
    {

        if (event.deltaY < 0)
        {
            lockEvent();
            scrollUp()

        }
        else if (event.deltaY > 0)
        {
            lockEvent();
            scrollDown()

        }
    });




}


setListeners(desktopDemo);
setListeners(mobileDemo);

var swipeApp = document.querySelector(".swipe-app");
var swipeAdmin = document.querySelector(".swipe-admin");

function setSwipeListeners(parentEl){
    var activeFeature = 0;
    var swiperContainers = parentEl.querySelectorAll(".swiper-container");
    var sheetFeatures = parentEl.querySelectorAll(".sheet-feature");
    var lastSwiper = null;

    function pickDefaultFeature(){
        pickFeature(activeFeature, true);
        return 1;
    }

    onViewChange.push(pickDefaultFeature);

    parentEl.querySelector(".bottom-sheet .title").addEventListener("click", bottomSheetToggle);
    parentEl.querySelector(".underlay").addEventListener("click", bottomSheetToggle);
    sheetFeatures.forEach(function(s){
        s.addEventListener("click", function(){
            var i = parseInt(this.getAttribute("data-sheet"));
            pickFeature(i);
            bottomSheetToggle();
        });
    });

    function pickFeature(num, cont = false){
        activeFeature = num;

        var thisElement =  parentEl.querySelector(".swipe-container-"+ num);

        if(thisElement.classList.contains("active") && !cont) return;

        swiperContainers.forEach(function(c){
            c.classList.remove("active")
        });

        sheetFeatures.forEach(function(s){
            s.classList.remove("active");
        });
        sheetFeatures[num].classList.add("active");

        thisElement.classList.add("active");

        if(lastSwiper){
            lastSwiper.destroy();
        }

        lastSwiper = new Swiper(thisElement, {
            slidesPerView: 1,
            spaceBetween: 30,
            // centeredSlides: true,
            // breakpoints: {
            //     576: {
            //         slidesPerView: 2,
            //         spaceBetween: 30,
            //     }
            // },
            pagination: {
                el: thisElement.querySelector(".swiper-pagination"),
                clickable: true,
            },
            navigation: {
                nextEl: thisElement.querySelector(".swiper-button-next"),
                prevEl: thisElement.querySelector(".swiper-button-prev"),
            },
        })
    }

    function bottomSheetToggle(){
        var sheet = parentEl.querySelector(".bottom-sheet");
        var underlay = parentEl.querySelector(".underlay");
        if(sheet.classList.contains("active")){
            sheet.classList.remove("active");
            underlay.classList.remove("active");
            sheet.style.top = "";
        } else {
            sheet.classList.add("active");
            underlay.classList.add("active");
            sheet.style.top = "calc(100% - "+sheet.offsetHeight+"px)"
        }

    }

    pickFeature(0)
}



setSwipeListeners(swipeApp);
setSwipeListeners(swipeAdmin);

window.selectView = function selectView(i){


    document.querySelectorAll(".flip-buttons button").forEach(function(button, index){
        if(i == index){
            button.classList.add("active");
        } else
            button.classList.remove("active");
    });


    if(i){
        desktopDemo.classList.add("active");
        mobileDemo.classList.remove("active");

        swipeApp.classList.remove("active");
        swipeAdmin.classList.add("active");

    } else {
        desktopDemo.classList.remove("active");
        mobileDemo.classList.add("active");

        swipeApp.classList.add("active");
        swipeAdmin.classList.remove("active");
    }

    onViewChange.forEach(function(fun){
        fun();

    })
};
selectView(0);


var images = document.querySelectorAll(".zoom-image");
var viewer = new ImageViewer.FullScreenViewer({});
console.log(images);
images.forEach( function(image){
    image.addEventListener("click", function(){
        viewer.show(image.getAttribute("src"))
    });
});

