

@extends("layouts.site", ["useJquery" => true])

@section("title", "Test de VvE app 30 dagen vrijblijvend via de trial.")
@section("description", "De trial geeft u de mogelijkheid om de Appartement VvE app geheel vrijblijvend te testen. Bespaar veel handelingen, kosten en frustraties en stap over naar een modern alternatief.")
@section("keywords", "VvE App Trial")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/contact.css')}}">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
@stop

@php
    $url = "https://customer-api.aprt.app/v2/Trial/";
    $env = Request::get('env');
    if($env === "staging"){
        $url = "https://customer-api-aprt.wb-s.app/v2/Trial/";
    }
@endphp

@section("after_js")
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script src="/js/jquery.validate.min.js"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <script>
        $(document).ready(function(){
            $.validator.addMethod("count", function(value, element) {
                var n = parseInt(element.value);
                if(!isNaN(n) && n > 0){
                    element.value = n;
                    return true;
                }
                return false;
            }, "Vul a.u.b. gehele getallen in");

            $.validator.addMethod("houseNumber", function(value, element){
                value = value.split(" ").join("");
                var regExp = new RegExp('^[0-9]{3,4}[A-Za-z]{1,2}$');
                return regExp.test(value);
            }, "");
            $.validator.addMethod("postCode", function(value, element){
                value = value.split(" ").join("");
                var regExp = new RegExp('^[0-9]{4}[A-Za-z]{2}$');
                return regExp.test(value);
            }, "");
            $.validator.addMethod("phoneNumber", function(value, element){
                var e = document.getElementById("phone-code-select");
                var code = e.options[e.selectedIndex].value;

                var regExp = new RegExp("\\+(9[976]\\d|00|8[987530]\\d|6[987]\\d|5[90]\\d|42\\d|3[875]\\d|2[98654321]\\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)([1-9])\\d{7,}$");
                return regExp.test(code + value);
            }, "")
        });

    </script>
    <script type="text/javascript">
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.fn.serializeFormJSON = function () {

            var o = {};
            var a = this.serializeArray();
            $.each(a, function () {
                if (o[this.name]) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || '');
                } else {
                    o[this.name] = this.value || '';
                }
            });
            return o;
        };

        var type = 0;

        function radioClicked(t){
            type = t;
            var burrons = document.querySelectorAll("#gpBtn button");

            for(var i =0; i< burrons.length; i++){
                burrons[i].classList.remove("activeW")
            }
            burrons[t].classList.add("activeW");

        }
        $.validator.addMethod(
            "regex",
            function(value, element, regexp) {
                var re = new RegExp(regexp);
                return this.optional(element) || re.test(value);
            }
        );



        $( document ).ready( function () {

            var validation = $( "#signupForm" ).validate( {
                onfocusout: function(element) {
                    $(element).valid();
                },
                rules: {
                    firstName: "required",
                    lastName: "required",
                    hoaName: "required",
                    "function": "required",
                    email: {
                        required: true,
                        email: true
                    },
                    phone: {
                        required:true,
                        phoneNumber: true,
                    },
                    houseNumber: {
                        required: true
                    },
                    postalCode:{
                        postCode: true
                    },
                    street: {
                        required: true
                    },
                    city: {
                        required: true
                    },
                    totalUnits: {
                        count: true
                    },
                },
                messages: {
                    firstName: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. jouw voornaam in.</p>",
                    lastName: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'>Voer hier a.u.b. jouw achternaam in.</p>",
                    hoaName: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. de naam van de VvE in.</p>",
                    email: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldig e-mailadres in (bijv. mail@voorbeeld.nl)</p>",
                    phone: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldig telefoonnummer</p>",
                    houseNumber: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldig huisnummer in</p>",
                    postalCode: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldige postcode in</p>",
                    street: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldige straatnaam in</p>",
                    city: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. de stad in</p>",
                    "function": "<p class='aantal'><img src='/img/icons/Icon-material-error.png'>Voer hier a.u.b. jouw functie in.</p>",
                    totalUnits: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Geef het aantal op a.u.b</p>"
                },
                errorElement: "em",
                errorPlacement: function ( error, element ) {
                    // Add the `invalid-feedback` class to the error element
                    error.addClass( "invalid-feedback" );

                    if ( element.prop( "type" ) === "checkbox" ) {
                        error.insertAfter( element.next( "label" ) );
                    } else {
                        error.insertAfter( element );
                    }
                },
                highlight: function ( element, errorClass, validClass ) {
                    $( element ).addClass( "is-invalid" ).removeClass( "is-valid" );
                    element.parentElement.classList.remove("parent-valid");
                },
                unhighlight: function (element, errorClass, validClass) {
                    $( element ).addClass( "is-valid" ).removeClass( "is-invalid" );
                    element.parentElement.classList.add("parent-valid");
                },
                submitHandler: function(form){
                    var data = $(form).serializeFormJSON();


                    if(type == 0){
                        data.gender = "Male";
                    } else {
                        data.gender = "Female";
                    }

                    data.hoaAddress = {
                        street: data.street,
                        postalCode: data.postalCode,
                        city: data.city,
                        houseNumber: data.houseNumber,
                        longitude: 0,
                        latitude: 0
                    };
                    data.functionTitle = data.function;
                    delete data.street;
                    delete data.postalCode;
                    delete data.city;
                    delete data.houseNumber;

                    var el = document.getElementById("phone-code-select");
                    var code = el.options[el.selectedIndex].value;
                    data.phone =  code + data.phone;

                    Swal.fire({
                        title: "Even geduld a.u.b.",
                        allowEscapeKey: false,
                        allowOutsideClick: false,
                        onOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    $.post({
                        url: "{{$url}}",
                        data: JSON.stringify(data),
                        success: (result)=>{
                            window.location = result.redirectUrl;
                            console.log(result);
                            // Swal.fire({
                            //     icon: 'success',
                            //     title: 'Form submitted',
                            //     onClose: ()=>{
                            //         location.href = "/bedankt";
                            //     }
                            // })
                            // location.href = "/bedankt";
                        },
                        dataType: "json",
                        contentType: "application/json; charset=utf-8",
                        error: (err)=> {
                            var errorMessage = "Onbekende fout";
                            if(err.responseJSON.error && err.responseJSON.error.length){
                                var errorCode = err.responseJSON.error[0].code;

                                if(errorCode === "Appartement.Trial.DuplicatePhoneNumber"){
                                    errorMessage = "Er is al een account gekoppeld aan het opgegeven telefoonnummer";
                                }
                                if(errorCode === "Appartement.Trial.DuplicateEmail"){
                                    errorMessage = "Er is al een account gekoppeld aan het opgegeven e-mailadres ";
                                }
                                if(errorCode === "Appartement.Trial.IpLimit"){
                                    errorMessage = "U kunt een nieuwe aanvraag indienen over 09:24 min.";
                                }
                                if(errorCode === "Appartement.Auth.InvalidPhoneFormat"){
                                    errorMessage = "Ongeldig telefoonnummer";
                                }
                            }
                            Swal.fire({
                                icon: "error",
                                title: "",
                                text: errorMessage
                            });
                            // var errors = "";
                            // for (let key in err.responseJSON.errors) {
                            //     errors += err.responseJSON.errors[key] + "<br/>"
                            // }
                            //
                            // var title = "Dit veld is niet correct ingevuld";
                            // if(err.responseJSON.message && !err.responseJSON.message.includes("was invalid")){
                            //     title = err.responseJSON.message
                            // }

                        }
                    });

                    return false

                }

            } );


            $( "#signupForm input" ).on( "input", function( e ) {

                    validation.element(e.target);

                }
            );


        } );

        function recaptchaCallback() {
            $('#submitBtn').removeAttr('disabled');
        }



    </script>



@stop

@section("content")

    <section class="section-contact">
        <div class="box-orange box-blue">
            <img class="mob-size" src="/img/shared/clouds-white.svg" alt="">
            <img class=" bulding-svg" src="/img/shared/city-white.svg" alt="">
            <img class="mob-size-city" src="/img/shared/buildings-white.svg" alt="">
            <div class="container">
                <h1>30 dagen trial</h1>
                <p>Geef hieronder de VvE-details aan:</p>
            </div>
        </div>
        <div class="container">
            <div class="tabs-pri">
                <div id="tab1" class="w3-container city cont-form">
                    <div class="eins-f">
                        <hr>
                        <p>Vul het onderstaande formulier in <img src="/img/icons/Icon-ionic-ios-arrow-dropdown.png"/> </p>
                        <hr>
                    </div>
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 offset-sm-2">
                                <div class="border-bottom">
                                    <div class="form-group row">
                                        <div class="col-md-3">
                                            <label>Aanhef</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="radio" name="gender" value="Male" id="genderMale" checked="checked"> <label for="genderMale" style="margin-right: 14px">Dhr.</label>
                                            <input type="radio" name="gender" value="Female" id="genderFemale"> <label for="genderFemale">Mevr.</label>
                                        </div>


                                    </div>
                                </div>
                                <form id="signupForm" class="form-horizontal">

                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="firstName">Voornaam <span>*</span></label>

                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="firstName" name="firstName" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="lastName">Achternaam <span>*</span></label>

                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="lastName" name="lastName" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="hoaName">Naam VvE<span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="hoaName" name="hoaName" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="vveCount">Aantal eenheden <span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="vveCount" name="totalUnits" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="function">Functie<span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="function" name="function" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-form-label col-lg-3" for="street">Straatnaam <span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="street" name="street"  />
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-form-label col-lg-3" for="houseNumber">Huisnummer <span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="houseNumber" name="houseNumber"  />
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="postalCode">Postcode <span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="postalCode" name="postalCode" />
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="city">Stad <span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="city" name="city" />
                                        </div>
                                    </div>


                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="email">E-mail <span>*</span></label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="email" name="email" placeholder="" />
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="phone">Telefoonnummer <span>*</span></label>
                                        <div class="col-lg-2 col-md-3 col-sm-4 col-5">
                                            <div class="phone-code">
                                                <select id="phone-code-select">
                                                    <option value="+31">+31</option>
                                                    <option value="+32">+32</option>
                                                    <option value="+599">+599</option>
                                                    <option value="+5997">+5997</option>
                                                </select>
                                                <span>(0)</span>
                                            </div>
                                        </div>
                                        <div class="col-lg-7 col-md-9 col-sm-8 col-7">
                                            <input type="tel" class="form-control" id="phone" name="phone" maxlength="13" />
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-lg-3 col-form-label" for="partnerCode">Partnercode</label>
                                        <div class="col-lg-9">
                                            <input type="text" class="form-control" id="partnerCode" name="partnerCode" placeholder="" />
                                        </div>
                                    </div>
                                    <div class="form-group form-textarea row">
                                        <label class="col-lg-3 col-form-label" for="comment">Opmerkingen</label>
                                        <div class="col-lg-9">
                                            <textarea name="comments" id="comment"  rows="10"></textarea>
                                        </div>
                                    </div>

                                    <div style="display: flex; justify-content: flex-end; margin-bottom: 10px">
                                        <div class="g-recaptcha" data-sitekey="6LckqrUZAAAAAFn19z-h1Cwpubl3Ot44K9Yc8APb" data-callback="recaptchaCallback"></div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-9"></div>
                                        <div class="col-md-3">
                                            <button type="submit" class="submit-button goto-button" id="submitBtn" disabled>VERZENDEN <span class="ml-2 fa fa-arrow-circle-right"></span></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </section>
    <section class="info">
        <div class="container">
            <div class="middl-content">
                <div class="row">
                    <div class="col-md-4">
                        <div class="middl-txt">
                            <img src="/img/icons/building-circular.png" alt="">
                            <div> Bezoekadres</div>
                            <ul>
                                <li><h3>Appartement App</h3></li>
                                <li><p>Onderdeel van WhiteBoard Studio B.V.</p></li>
                                <li><p>Poort van Uden</p></li>
                                <li><p>Rondweg 55</p></li>
                                <li><p>5406 NK Uden</p></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="middl-txt box-txt">
                            <img src="/img/icons/message-circular.png" alt="">
                            <div>Contact</div>
                            <ul>
                                <li><p>info@app-artement.nl</p></li>
                                <li><p>www.app-artement.nl</p></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="middl-txt">
                            <img src="/img/icons/briefcase-circular.png" alt="">
                            <div> Zakelijk</div>
                            <ul>
                                <li><p>KvK: 67189334</p></li>
                                <li><p>BTW: NL856867858B01</p></li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>


@stop
