

@extends("layouts.site", ["useJquery" => true])

@section("title", "Neem contact op in het geval van vragen, aanvragen van een trial en meer.")
@section("description", "Neem contact op met onze medewerkers wanneer u vragen heeft over de app, prijzen, trials en meer. Onze klantenservice staat klaar voor u.")
@section("keywords", "Contact Appartement App")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/contact.css')}}">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
@stop

@section("after_js")
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script src="/js/jquery.validate.min.js"></script>
    <script>
        $(document).ready(function(){
            $.validator.addMethod("count", function(value, element) {
                var n = parseInt(element.value);
                if(!isNaN(n) && n > 0){
                    element.value = n;
                    return true;
                }
                return false;
            }, "Vul a.u.b. gehele getallen in");

            $.validator.addMethod("houseNumber", function(value, element){
                value = value.split(" ").join("");
                var regExp = new RegExp('^[0-9]{3,4}[A-Za-z]{1,2}$');
                return regExp.test(value);
            }, "");
            $.validator.addMethod("postCode", function(value, element){
                value = value.split(" ").join("");
                var regExp = new RegExp('^[0-9]{4}[A-Za-z]{2}$');
                return regExp.test(value);
            }, "")
        });

    </script>
    <script type="text/javascript">
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var package = getParameterByName("package");
        $.fn.serializeFormJSON = function () {

            var o = {};
            var a = this.serializeArray();
            $.each(a, function () {
                if (o[this.name]) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || '');
                } else {
                    o[this.name] = this.value || '';
                }
            });
            return o;
        };

        var type = 0;

        function radioClicked(t){
            type = t;
            var burrons = document.querySelectorAll("#gpBtn button");

            for(var i =0; i< burrons.length; i++){
                burrons[i].classList.remove("activeW")
            }
            burrons[t].classList.add("activeW");

            document.querySelector("#nameLabelChange").innerHTML = type == 0 ? 'Naam VvE<span>*</span>' : 'Naam beheerder<span>*</span>';
            document.querySelector("#countLabelChange").innerHTML = type == 0 ? 'Aantal eenheden <span>*</span>' : 'Aantal VvE’s <span>*</span>';
        }
        $.validator.addMethod(
            "regex",
            function(value, element, regexp) {
                var re = new RegExp(regexp);
                return this.optional(element) || re.test(value);
            }
        );



        $( document ).ready( function () {

            var validation = $( "#signupForm" ).validate( {
                onfocusout: function(element) {
                    $(element).valid();
                },
                rules: {
                    contactPerson: "required",
                    name: "required",
                    email: {
                        required: true,
                        email: true
                    },
                    phone: {
                        required:true,
                        minlength: 10
                    },
                    vveCount: {
                        count: true
                    },
                    houseNumber: {
                        required: true
                    },
                    postCode:{
                        postCode: true
                    },
                    street: {
                        required: true
                    },
                    city: {
                        required: true
                    },
                    "function": {
                        required: true
                    }
                },
                messages: {
                    contactPerson: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. de naam van een contactpersoon in.</p>",
                    "function": "<p class='aantal'><img src='/img/icons/Icon-material-error.png'>Voer hier a.u.b. de naam van een functie in.</p>",
                    name: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. de naam van de VvE in.</p>",
                    email: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldig e-mailadres in (bijv. mail@voorbeeld.nl)</p>",
                    phone: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier alleen getallen in zonder streepje</p>",
                    vveCount: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Geef het aantal op a.u.b</p>",
                    houseNumber: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldig huisnummer in</p>",
                    postCode: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldige postcode in</p>",
                    street: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldige straatnaam in</p>",
                    city: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. de stad in</p>",
                },
                errorElement: "em",
                errorPlacement: function ( error, element ) {
                    // Add the `invalid-feedback` class to the error element
                    error.addClass( "invalid-feedback" );

                    if ( element.prop( "type" ) === "checkbox" ) {
                        error.insertAfter( element.next( "label" ) );
                    } else {
                        error.insertAfter( element );
                    }
                },
                highlight: function ( element, errorClass, validClass ) {
                    $( element ).addClass( "is-invalid" ).removeClass( "is-valid" );
                    element.parentElement.classList.remove("parent-valid");
                },
                unhighlight: function (element, errorClass, validClass) {
                    $( element ).addClass( "is-valid" ).removeClass( "is-invalid" );
                    element.parentElement.classList.add("parent-valid");
                },
                submitHandler: function(form){
                  var data = $(form).serializeFormJSON();

                  data.vveType = type == 1 ? 0 : 1;

                  var tabType = document.querySelector(".tabs button.active").getAttribute("data-active");
                  data.package = package;

                  if(tabType == 1){
                      data.type = "Algemene vraag"
                  } else if(tabType == 2){
                      data.type = "30 dagen trial"
                  } else {
                      data.type = "White Label"
                  }
                  Swal.fire({
                      title: "Even geduld a.u.b.",
                      allowEscapeKey: false,
                      allowOutsideClick: false,
                      onOpen: () => {
                          Swal.showLoading();
                      }
                  });

                    $.post({
                        url: "/api/form/contact",
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                        data: data,
                        success: (result)=>{
                            // Swal.fire({
                            //     icon: 'success',
                            //     title: 'Form submitted',
                            //     onClose: ()=>{
                            //         location.href = "/bedankt";
                            //     }
                            // })
                            location.href = "/bedankt";
                        },
                        dataType: "json",
                        error: (err)=> {
                            var errors = "";
                            for (let key in err.responseJSON.errors) {
                                errors += err.responseJSON.errors[key] + "<br/>"
                            }

                            var title = "Dit veld is niet correct ingevuld";
                            if(err.responseJSON.message && !err.responseJSON.message.includes("was invalid")){
                                title = err.responseJSON.message
                            }

                            Swal.fire({
                                icon: "error",
                                title: title,
                                html: errors
                            })
                        }
                    });

                    return false

                }

            } );
            console.log(validation);


            $( "#signupForm input" ).on( "input", function( e ) {
                console.log(e.target);
                // if ( this.name in validation.submitted || this.name in validation.invalid ) {
                //     validation.element(this);
                // }

                    validation.element(e.target);

            }
                );
            // $( "#signupForm" ).on( "autocomplete", function(e){
            //     console.log(e);
            // })

        } );

        function sendTrialData(){

        }

        var tabButtons = document.querySelectorAll(".tabs button");

        for(var i=0; i < tabButtons.length; i++){

            tabButtons[i].addEventListener("click", function(){
                if(this.getAttribute("data-active") == 2) {
                    window.location.href = "/30-day-trial";
                    return
                }
                if(this.getAttribute("data-active") == 4){
                    window.location.href = "/helpdesk";
                    return;
                }
                scrollToElement(document.getElementById("tab1"), 300);
                document.querySelector(".tabs button.active").classList.remove("active");
                this.classList.add("active");
                // document.querySelector(".tab-data.active").classList.remove("active");
                // document.querySelector("div.tab-data:nth-of-type("+ this.getAttribute("data-active") + ")").classList.add("active");



                if(this.getAttribute("data-active") == 4) {
                    document.getElementsByClassName("tabs-pri")[0].style.display="none";
                    document.getElementById("btn-come").style.display="block";
                } else {
                    document.getElementById("btn-come").style.display="none";
                    document.getElementsByClassName("tabs-pri")[0].style.display="block"
                }

            })
        }

        if(window.location.hash === "#trial") {
            tabButtons[1].click();
        }

        if(window.location.hash === "#white-label") {
            tabButtons[2].click();
        }




    </script>



@stop

@section("content")

    <section class="section-contact">
        <div class="box-orange box-blue">
            <img class="mob-size" src="/img/shared/clouds-white.svg" alt="">
            <img class=" bulding-svg" src="/img/shared/city-white.svg" alt="">
            <img class="mob-size-city" src="/img/shared/buildings-white.svg" alt="">
            <div class="container">
                    <h1>Contact</h1>
                    <p>Geef hieronder aan over welk onderwerp u contact wenst:</p>
                    <div class="tabs">
                        <button id="tb-1" class="active" data-active="1"><img src="/img/about-us/icon-chat.svg" alt="">Algemene vraag </button>
                        <button data-active="2"><img src="/img/contact/icon-flask.png" alt="">30 dagen trial </button>
                        <button data-active="3"><img src="/img/home/slide-private-label.png" alt="">White Label </button>
                        <button data-active="4"><img src="/img/contact/icon-support.png" alt=""> Technische support</button>
                    </div>

            </div>
        </div>
        <div class="container">
            <div class="tabs-pri">
                        <div id="tab1" class="w3-container city cont-form">
                            <div class="eins-f">
                                <hr>
                                <p>Vul het onderstaande formulier in <img src="/img/icons/Icon-ionic-ios-arrow-dropdown.png"/> </p>
                                <hr>
                            </div>
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-12 offset-sm-2">
                                        <div class="border-bottom">
                                            <div class="form-group row">
                                                <div class="col-md-3">
                                                    <label class="lab" for="gpBtn">Maak uw keuze:</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <div class="btn-gp" id="gpBtn">
                                                        <button id="btnOne" onclick="radioClicked(0)" class="btn-form activeW">VvE bestuurder</button>
                                                        <button id="btnTwo" onclick="radioClicked(1)" class="btn-form">VvE beheerder</button>
                                                    </div>
                                                </div>


                                            </div>
                                        </div>
                                        <form id="signupForm" class="form-horizontal">


                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="contactPerson">Naam contactpersoon <span>*</span></label>

                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="contactPerson" name="contactPerson" placeholder="" />
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="function">Functie <span>*</span></label>

                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="function" name="function" placeholder="" />
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="name" id="nameLabelChange">Naam VvE<span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="name" name="name" placeholder="" />
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="vveCount" id="countLabelChange">Aantal eenheden <span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="vveCount" name="vveCount" placeholder="" />
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-lg-3" for="street">Straatnaam <span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="street" name="street"  />
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-lg-3" for="houseNumber">Huisnummer <span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="houseNumber" name="houseNumber"  />
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="postCode">Postcode <span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="postCode" name="postCode" />
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="city">Stad <span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="city" name="city" />
                                                </div>
                                            </div>


                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="email">E-mail <span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="text" class="form-control" id="email" name="email" placeholder="" />
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label class="col-lg-3 col-form-label" for="phone">Telefoonnummer <span>*</span></label>
                                                <div class="col-lg-9">
                                                    <input type="tel" class="form-control" id="phone" name="phone" placeholder="" maxlength="13" />
                                                </div>
                                            </div>

                                            <div class="form-group form-textarea row">
                                                <label class="col-lg-3 col-form-label" for="comment">Opmerkingen</label>
                                                <div class="col-lg-9">
                                                    <textarea name="comment" id="comment"  rows="10"></textarea>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-md-9"></div>
                                                <div class="col-md-3">
                                                    <button type="submit" class="submit-button goto-button">VERZENDEN <span class="ml-2 fa fa-arrow-circle-right"></span></button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
            <div id="btn-come">
                <div class="coming-soon">
                    <div>
                        <img src="/img/coming-soon.png"/>
                    </div>
                    Coming soon
                </div>
            </div>
        </div>

    </section>
    <section class="info">
        <div class="container">
            <div class="middl-content">
                <div class="row">
                    <div class="col-md-4">
                        <div class="middl-txt">
                            <img src="/img/icons/building-circular.png" alt="">
                            <div> Bezoekadres</div>
                            <ul>
                                <li><h3>Appartement App</h3></li>
                                <li><p>Onderdeel van WhiteBoard Studio B.V.</p></li>
                                <li><p>Poort van Uden</p></li>
                                <li><p>Rondweg 55</p></li>
                                <li><p>5406 NK Uden</p></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="middl-txt box-txt">
                            <img src="/img/icons/message-circular.png" alt="">
                            <div>Contact</div>
                            <ul>
                                <li><p>info@app-artement.nl</p></li>
                                <li><p>www.app-artement.nl</p></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="middl-txt">
                            <img src="/img/icons/briefcase-circular.png" alt="">
                            <div> Zakelijk</div>
                            <ul>
                                <li><p>KvK: 67189334</p></li>
                                <li><p>BTW: NL856867858B01</p></li>
                            </ul>
                        </div>
                    </div>
                </div>

                </div>
        </div>
    </section>


@stop
