@extends("layouts.site",  ["headerColor" => "dark"])

@section("title", "Bekijk de vve app demo voor een beter beeld van de app en admin portal.")
@section("description", "Appartement App demo. Bekijk de verschillende functies van de Appartement App en de Admin Portal. Vraag direct een trial van 30 dagen aan.")
@section("keywords", "demo vve app")

@section("after_css")

    <link rel="stylesheet" href="/css/swiper.css" />
    <link rel="stylesheet" href="/css/iv-viewer.min.css">
    <link rel="stylesheet" href="{{mix('/css/pages/demo.css')}}">
@stop

@section("after_js")
    <script src="https://hammerjs.github.io/dist/hammer.min.js"></script>
    <script src="/js/swiper.min.js"></script>
    <script src="/js/iv-viewer.min.js"></script>
    <script src="{{mix('/js/pages/demo.js')}}"></script>

@stop

@php
$desktopFeatures = [
        [
            "name" => "Dashboard",
            "icon" => "/img/demo/icon-desktop.svg",
            "parts" => [
                [
                    "img" => "/img/demo/desktop-dashboard.jpg",

                    "title" => "Dashboard",
                    "description" => "Via het dashboard kunnen beheerders en bestuurders handige statistieken bekijken. Dit gedeelte wordt continu uitgebreid met nieuwe statistieken en functies.",
                ]
            ]
        ], [
            "name" => "VvE overzicht",
            "icon" => "/img/demo/icon-buildings.svg",
             "parts" => [
                [
                    "img" => "/img/demo/vve-overzicht-1.jpg",
                    "title" => "VvE overzicht",
                    "description" => "Voor beheerders en gebruikers die meerdere VvE’s beheren, is er een handig overzicht van alle VvE’s in beheer. Schakel gemakkelijk tussen VvE’s en behoud het overzicht.",
                ], [
                    "img" => "/img/demo/vve-overzicht-2.jpg",
                    "title" => "VvE toevoegen",
                    "description" => "Voeg gemakkelijk nieuwe VvE’s toe en richt deze in zoals gewenst.",
                ]
            ]
        ],[
            "name" => "Gebouw toevoegen",
            "icon" => "/img/demo/icon-building.svg",
            "parts" => [
                [
                    "img" => "/img/demo/desktop-add-building.jpg",
                    "title" => "Gebouw toevoegen",
                    "description" => "Voeg gemakkelijk nieuwe VvE’s toe en richt deze in zoals gewenst."
                ]
            ]
        ],[
            "name" => "Bouwdelen toevoegen",
            "icon" => "/img/demo/icon-building-plus.svg",
            "parts" => [
                [
                    "img" => "/img/demo/desktop-add-part-1.jpg",
                    "title" => "Bouwdelen toevoegen",
                    "description" => "Voeg bouwdelen toe en geef de exacte structuur op van het gebouw. Ook parkeerunits en bergingsruimtes kunnen hier toegevoegd worden."
                ],[
                    "img" => "/img/demo/desktop-add-part-2.jpg",
                    "title" => "Overzicht bouwdelen",
                    "description" => "Bekijk alle bouwdelen en aan welke bewoners deze zijn gekoppeld. Wijzig de gegevens snel en gemakkelijk."
                ]
            ]
        ],[
            "name" => "Prikbord",
            "icon" => "/img/demo/icon-pin.svg",
            "parts" => [
                 [
                    "img" => "/img/demo/desktop-pinboard.jpg",
                    "title" => "Prikbord",
                    "description" => "Bekijk een overzicht van alle belangrijke en algemene berichten op het prikbord. Vanuit hier kunnen statussen aan berichten worden gegeven en nog veel meer."
                ],[
                    "img" => "/img/demo/desktop-post.jpg",
                    "title" => "Prikbord bericht",
                    "description" => "Bekijk en beheer berichten die door bestuurders en leden zijn geplaatst. Maak hier nieuwe berichten aan die zichtbaar worden in de app"
                ]
            ]
        ],[
            "name" => "Bestuursleden",
            "icon" => "/img/demo/icon-people.svg",
            "parts" =>[
                 [
                    "img" => "/img/demo/desktop-board-member.jpg",
                    "title" => "Bestuursleden",
                    "description" => "Handig overzicht van alle bestuursleden en de contactgegevens van deze leden."
                ]
            ]
        ]

    ];

$mobileFeatures =  [
        [
            "name" => "Algemene functies",
            "icon" => "/img/demo/icon-options.svg",
            "parts" => [
                [
                    "img" => "/img/demo/phone-home.jpg",
                    "title" => "Home",
                    "description" => "Vanuit het startscherm ‘home’ kunnen gebruikers direct één van de meest gebruikte acties selecteren.",
                ]
            ]
        ], [
            "name" => "Communicatie",
            "icon" => "/img/demo/message.svg",
             "parts" => [
                [
                    "img" => "/img/demo/phone-push-message.jpg",
                    "title" => "Push messages",
                    "description" => "Berichten en aankondigingen kunnen snel en gemakkelijk verstuurd worden.  Door gebruik te maken van ‘pushberichten’ ontgaat gebruikers helemaal niets!",
                ], [
                    "img" => "/img/demo/phone-messages.jpg",
                    "title" => "Chat/berichten",
                    "description" => "Snelle en directe communicatie verloopt via een geavanceerde chatfunctie. Stuur privé berichten of maakeen groep aan en stuur direct berichten en bijlagen!",
                ],[
                    "img" => "/img/demo/phone-pinboard.jpg",
                    "title" => "Prikbord",
                    "description" => "Via een social platform kunnen bestuurders en bewoners berichten plaatsen, liken en reageren."
                ]
            ]
        ], [
            "name"=> "Onderhoud, beheer & planning",
            "icon" => "/img/demo/icon-calendar.svg",
                "parts" => [
                [
                 "img" => "/img/demo/phone-calendar.jpg",
                 "title" => "Kalenderbeheer",
                 "description" => "Bestuurders maken evenementen aan zoals een algemene ledenvergadering. Deze worden via een pushbericht verstuurd om gebruikers actiever te laten deelnemen."
                ],[
                 "img" => "/img/demo/phone-documents.jpg",
                 "title" => "Documenten",
                 "description" => "Documenten zoals aktes, het MJOP, jaarstukken en notulen kunnen gemakkelijk en snel ingezien worden."
                ],[
                 "img" =>"/img/demo/phone-repair.jpg",
                 "title" =>"Reparatieverzoek",
                 "description" => "Gebruikers kunnen gemakkelijk een reparatieverzoek indienen die vervolgens bij de juiste persoon terecht komt. Dit zorgt voor korte lijnen en een snellere afhandeling."
                ]
            ],
        ], [
            "name"=> "Stemmen",
            "icon" => "/img/demo/icon-voting.svg",
                "parts" => [
                [
                 "img" => "/img/demo/phone-voting.jpg",
                 "title" => "Stemmen",
                 "description" => "Maak stemmingen aan. Leden kunnen (op afstand) stemmen over belangrijke zaken via de app. Digitale ondertekening. Volledig rechtsgeldig."
                ]
            ],
        ]
    ]
@endphp

@section("content")
    <section class="demo-wrapper">
        <div class="flip-buttons">
            <button onclick="selectView(0)">
                <i class="material-icons">smartphone</i>
                APP
            </button>
            <button onclick="selectView(1)">
                <i class="material-icons">desktop_windows</i>
                ADMIN PORTAL
            </button>
        </div>
        <div class="container">
            <div class="desktop-demo demo">
                <div class="pick-feature">
                    <div class="title">FUNCTIES BEHEERDERS</div>
                    @foreach($desktopFeatures as $i => $feature)
                        <div class="feature {{$loop->iteration === sizeof($desktopFeatures) ? "last-shit" : ""}}" data-feature="{{$i}}">
                            <img src="{{$feature["icon"]}}"/>
                            <span>{{$feature["name"]}}  <div class="count">({{sizeof($feature["parts"])}})</div></span>
                            <i class="material-icons">keyboard_arrow_right</i>
                        </div>
                    @endforeach
                    <div class="col-icon">
                        @component("components.store-links")
                            @slot("white", true)
                            @slot("hideAvg", true)
                        @endcomponent
                    </div>
                </div>

                <div class="preview">
                    <div class="shield-box"><img src="/img/demo/Icon-awesome-shield-alt.png" alt=""><strong>AVG </strong><strong>PROOF</strong></div>
                @foreach($desktopFeatures as $i => $feature)
                        <div class="feature feature-{{$i}}">
                        @foreach($feature["parts"] as $j => $part)
                            <div class="preview preview-{{$j}}">
                                <img src="{{$part['img']}}"/>
                                <div class="about">
                                    <div class="ding-dong">
                                        <div></div>
                                    </div>
                                    <div class="title">
                                        <img src="{{$feature["icon"]}}"/> {{$part["title"]}}
                                    </div>
                                    <p>
                                        {{$part["description"]}}
                                    </p>
                                </div>
                            </div>
                            @endforeach
                        </div>

                    @endforeach
                </div>
                <div class="preview-picker"></div>


            </div>
            <div class="mobile-demo demo">
                <div class="pick-feature">
                    <div class="title">FUNCTIES BEWONERS</div>
                    @foreach($mobileFeatures as $i => $feature)
                        <div class="feature {{$loop->iteration == sizeof($mobileFeatures) ? "last-shit" : ""}}" data-feature="{{$i}}">
                            <img src="{{$feature["icon"]}}"/>
                            <span>{{$feature["name"]}} <div class="count">({{sizeof($feature["parts"])}})</div></span>
                            <i class="material-icons">keyboard_arrow_right</i>
                        </div>
                    @endforeach
                    <div class="col-icon">
                        @component("components.store-links")
                            @slot("white", true)
                            @slot("hideAvg", true)
                        @endcomponent
                    </div>
                </div>
                <div class="preview">
                    <div class="shield-box shield-mob"><img src="/img/demo/Icon-awesome-shield-alt.png" alt=""><strong>AVG </strong><strong>PROOF</strong></div>
                @foreach($mobileFeatures as $i => $feature)
                        <div class="feature feature-{{$i}}">
                            @foreach($feature["parts"] as $j => $part)
                                <div class="preview preview-{{$j}}">
                                    <div class="mobile-preview">
                                        <div class="about">
                                            <div class="ding-dong">
                                                <div></div>
                                            </div>
                                            <div class="title">
                                                <img src="{{$feature["icon"]}}"/> {{$part["title"]}}
                                            </div>
                                            <p>
                                                {{$part["description"]}}
                                            </p>
                                        </div>
                                        <div class="iphone">

                                            <img src="{{$part['img']}}"/>
                                            <div class="frame"></div>
{{--                                            <div class="fader"></div>--}}
                                        </div>


                                    </div>

                                </div>
                            @endforeach
                        </div>

                    @endforeach

                </div>
                <div class="preview-picker">
                </div>

            </div>

            <div class="swipe-part swipe-app">
                @foreach($mobileFeatures as $i => $feature)
                    <div class="swiper-container swipe-container-{{$i}}">
                        <div class="swiper-wrapper">
                            @foreach($feature["parts"] as $part)
                                <div class="swiper-slide">
                                    <div class="the-slide">
                                        <img src="{{$part["img"]}}">
                                        <div class="title">
                                            <img src="{{$feature["icon"]}}"/>
                                            {{$part["title"]}}
                                        </div>
                                        <p>{{$part["description"]}}</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="swiper-pagination swiper-pagination-{{$i}}"></div>
                        @if(sizeof($feature["parts"]) > 1)
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        @endif
                    </div>
                @endforeach

                <div class="bottom-sheet">
                    <div class="title">FUNCTIES BEWONERS</div>

                    @foreach($mobileFeatures as $i => $feature)
                    <div class="sheet-feature sheet-feature-{{$i}}" data-sheet="{{$i}}">
                        <img src="{{$feature["icon"]}}"/>
                        {{$feature["name"]}}
                    </div>
                    @endforeach



                </div>

                <div class="underlay"></div>

            </div>
            <div class="swipe-part swipe-admin">
                @foreach($desktopFeatures as $i => $feature)
                    <div class="swiper-container swipe-container-{{$i}}">
                        <div class="swiper-wrapper">
                            @foreach($feature["parts"] as $part)
                                <div class="swiper-slide">
                                    <div class="the-slide">
                                        <img class="zoom-image" src="{{$part["img"]}}" data-high-res-src="{{$part['img']}}">
                                        <div class="title">
                                            <img src="{{$feature["icon"]}}"/>{{$part["title"]}}
                                        </div>
                                        <p>{{$part["description"]}}</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="swiper-pagination swiper-pagination-{{$i}}"></div>
                        @if(sizeof($feature["parts"]) > 1)
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                        @endif
                    </div>
                @endforeach

                <div class="bottom-sheet">
                    <div class="title">FUNCTIES BEWONERS</div>

                    @foreach($desktopFeatures as $i => $feature)
                        <div class="sheet-feature sheet-feature-{{$i}}" data-sheet="{{$i}}">
                            <img src="{{$feature["icon"]}}"/>
                            {{$feature["name"]}}
                        </div>
                    @endforeach



                </div>

                <div class="underlay"></div>
            </div>
        </div>

        <div class="scroll-info">
            <img src="/img/demo/scroll.svg"/>
            <span>SCROLL VOOR <br/> MEER FUNCTIES</span>
        </div>
    </section>




@stop
