@extends("layouts.site")

@section("title", "VvE App (Best getest 2020) VvE Software + Mobiele App")
@section("description", "Dé VvE App. De moderne VvE software waarmee u uw VvE leden (sneller, gemakkelijker en efficiënter) bereikt. Met de ´Appartement´ App garanderen wij korte lijnen tussen het bestuur en de bewoners via een smartphone of tablet. Als best getest door VvE bewoners.")
@section("keywords", "vve app")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/home.css')}}" />
    <link rel="stylesheet" href="/css/swiper.css" />
    <style>
        .swiper-container {
            width: 100%;
            padding: 40px;
            padding-bottom: 60px;

        }
        .swiper-slide {

            display: -webkit-box;
            display: -ms-flexbox;
            display: -webkit-flex;
            display: flex;
            -webkit-box-pack: center;
            -ms-flex-pack: center;
            -webkit-justify-content: center;
            justify-content: center;
            -webkit-box-align: center;
            -ms-flex-align: center;
            -webkit-align-items: center;
            align-items: center;
        }
    </style>

@stop

@section("after_js")
    <script src="/js/swiper.min.js"></script>
    <script>

        // var swiperContainer = document.querySelector(".swiper-container");
        //
        // function getItem(slides, i){
        //     return slides[i].querySelector(".slider-item");
        // }

        var next = document.querySelector(".swipe-section .swiper-button-next");
        var previous = document.querySelector(".swipe-section .swiper-button-prev");

        var pagination = document.querySelector(".swipe-section .swiper-container .swiper-pagination");
        new Swiper(document.querySelector('.swipe-section .swiper-container'), {
            slidesPerView: 1,
            spaceBetween: 20,
            centeredSlides: true,
            loop: false,
            initialSlide: 2,
            pagination: {
                el: pagination,
                clickable: true,
            },
            breakpoints: {
                768 : {
                    slidesPerView: 2
                },
                992: {
                    slidesPerView: 3,
                },

            },   navigation: {
                nextEl: next,
                prevEl: previous,
            },
            // on: {
            //     transitionEnd : function(){
            //         let orders = swiperContainer.querySelectorAll(".order-1, .order-2, .order-3");
            //
            //         for(var i =0; i < orders.length; i++){
            //             orders[i].classList.remove("order-1", "order-2", "order-3");
            //         }
            //
            //         var slides = swiperContainer.querySelectorAll(".swiper-slide");
            //
            //         i = this.activeIndex;
            //
            //         getItem(slides, i).classList.add("order-1");
            //         if(i + 1 < slides.length){
            //             getItem(slides, i+1).classList.add("order-2")
            //         }
            //         if(i + 2 < slides.length){
            //             getItem(slides, i+2).classList.add("order-3")
            //         }
            //         if(i - 1 > -1){
            //             getItem(slides, i-1).classList.add("order-2")
            //         }
            //         if(i - 2 > -1){
            //             getItem(slides, i-2).classList.add("order-3")
            //         }
            //
            //     }
            // }
        });

        function setSwiper(selector){
            var main = document.querySelector(selector);
            var pagination = main.querySelector(".swiper-pagination");
            var next = main.querySelector(".swiper-button-next");
            var previous = main.querySelector(".swiper-button-prev");

            new Swiper(main,  {
                slidesPerView: 1.5,
                spaceBetween: 20,
                centeredSlides: true,
                loop: false,
                initialSlide: 1,
                breakpoints: {
                    576: {
                        slidesPerView: 2,
                    }
                },

                pagination: {
                    el: pagination,
                    clickable: true,
                },
                navigation: {
                    nextEl: next,
                    prevEl: previous,
                },
            })

        }

        setSwiper(".count-section .swiper-container");
        setSwiper('.quotes .swiper-container');
        setSwiper(".software-section .swiper-container");


    </script>
    <script>
        var descriptionParts = document.querySelectorAll('.description-part');

        descriptionParts.forEach(function(part){
            var openBtn = part.querySelector('.open-button');
            var closeBtn = part.querySelector('.close-button');
            if(openBtn && closeBtn){
                openBtn.addEventListener("click",function(){
                    part.classList.add('opened');
                    scrollToElement(part, 400, 80)
                });
                closeBtn.addEventListener("click",function(){
                    part.classList.remove('opened');

                    scrollToElement(part, 400, 80)
                });
            }

        });
    </script>
@stop

@php
    $slideItems = [
        [
            "title" => "Meer betrokkenheid",
            "img" => "/img/home/slide-involve.svg",
            "description" => "Lagere drempel, meer deelname"
        ], [
            "title" => "Directe communicatie",
            "img" => "/img/home/slide-communication.png",
            "description" => "Korte lijnen tussen bewoners en VvE"
        ], [
            "title" => "Private label",
            "img" => "/img/home/slide-private-label.png",
            "description" => "Eigen look and feel mogelijk"
        ], [
            "title" => "AVG proof",
            "img" => "/img/home/slide-shield.png",
            "description" => "Alles volgens de AVG wet. Veiligheid en privacy voorop."
        ], [
            "title" => "Alles binnen handbereik",
            "img" => "/img/home/slide-reach.png",
            "description" => "Korte lijnen tussen bewoners en VvE"
        ], [
            "title" => "Geen dubbele meldingen",
            "img" => "/img/home/slide-notification.png",
            "description" => "Reparatie meldingen voor iedereen zichtbaar. Dubbele melding herkenning."
        ]
    ];

    $countCards = [
        [
            "count" => "80%",
            "img" => "/img/home/solution-chat.svg",
            "description" => "Van de respondenten geeft aan dat de communicatie met de VvE stroef verloopt"
        ],  [
            "count" => "72%",
             "img" => "/img/home/solution-message.svg",
            "description" => "Van de respondenten weet niet direct wat te doen bij een aanvraag/verzoek"
        ],  [
            "count" => "57%",
            "img" => "/img/home/slide-communication.png",
            "description" => "Van de respondenten geeft aan meer betrokken te willen"
        ]
    ];

    $quoteCards = [
        [
            "name" => "Jaap",
            "location" => "VvE, Amsterdam",
            "content" => "‘Sinds het gebruik van de app hebben wij geen vervelende dubbele meldingen meer. ’"
        ],  [
            "name" => "Mariska",
            "location" => "VvE, Den Haag",
            "content" => "‘Typisch een product dat je eerder had moeten hebben. Onze leden zijn er erg blij mee. We hebben een stuk minder ergernissen. Ook de leden die het in eerste instantie niet wilden gebruiken zijn nu om’"
        ],  [
            "name" => "Piet",
            "location" => "VvE, Alphen aan den Rijn",
            "content" => "'De app is fantastisch. Wij gebruiken de app dagelijks en het heeft ons leven een stuk makkelijk gemaakt!’"
        ]
    ];

    $softwareCards = [
        [
            "name" => "Software voor VvE Bestuurders",
            "img" => "/img/software/software-analytics.svg",
            "button" => "MEER INFORMATIE",
            "link" => "/software#vve-bestu"
        ],  [
            "name" => "Software voor VvE Beheerders",
            "img" => "/img/software/software-config.svg",
            "button" => "MEER INFORMATIE",
            "link" => "/software#vve-beheer"
        ],  [
            "name" => "White Label?",
            "img" => "/img/software/software-customize.svg",
            "button" => "BEKIJK DE VOORDELEN",
            "link" => "/white-label"
        ]
    ];

@endphp

@section("content")

    <section class="section-one light-bg bg-one-section"  id="home">
        <img class="cloud-home" src="/img/cloud-home.png" alt="">
        <div class="container" style="z-index: 2; position: relative">
            <div class="row">
                <div class="col-md-6 order-2 order-md-1">
                    <div class="image-wrapper">
                        <img src="/img/home/phones.png" alt="desktop mobile app"/>
                    </div>
                </div>
                <div class="col-md-6 order-1 order-md-2">
                    <div class="content-one">
                        <h1>Dé app voor VvE Nederland</h1>
                        <p>Bereik uw VvE leden sneller, gemakkelijker en efficiënter met de Appartement App. De enige app die speciaal is ontwikkeld voor VvE’s.</p>
                        <a href="/demo" class="goto-button">BEKIJK DEMO</a>

                        <div class="lower-links">
                            @component("components.store-links")@endcomponent
                        </div>

                    </div>

                </div>
            </div>
        </div>
        <img class="appartement-home" src="/img/appartement-home.png" alt="">
    </section>
    {{--    <section class="section-two">--}}
    {{--        <h2 class="reveal fadeInUp">Alles onder één dak</h2>--}}
    {{--        <h3 class="reveal fadeInUp">Bekijk per verdieping de verschillende functies, in een korte animatiefilm</h3>--}}
    {{--        <div class="bg-himmel">--}}
    {{--            <div class="himmel-btn">--}}
    {{--                <a href="#" class="button-one reveal fadeInUp">BEKIJK VOLLEDIGE DEMO<span class="ml-2 fa fa-arrow-circle-right" aria-hidden="true"></span></a>--}}
    {{--            </div>--}}
    {{--        </div>--}}
    {{--    </section>--}}
    <section class="space spacee swipe-section">
        <div class="container">
            <h2 class="space-item">De Appartement App vermindert frustraties, <br/>
                verbetert de communicatie & de sfeer</h2>
            {{--            <div class="swiper-container">--}}
            {{--                <div class="swiper-wrapper">--}}
            {{--                    --}}
            {{--                </div>--}}
            {{--                <div class="swiper-button-next"></div>--}}
            {{--                <div class="swiper-button-prev"></div>--}}
            {{--                <div class="swiper-pagination"></div>--}}
            {{--            </div>--}}

            <div class="row">
                @foreach($slideItems as $slide)
                    <div class="col-lg-4 col-md-6">
                        <div class="slider-item">
                            <img src="{{$slide["img"]}}" alt="feature image"/>
                            <div class="title">{{$slide["title"]}}</div>
                            <div class="desc">{{$slide["description"]}}</div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="text-center">
                <div class="container">
                    <div class="description-part  read-more">
                        <p> VvE App ‘Appartement’ voor smartphones en tablets verbindt het bestuur met de bewoners van een VvE.</p>
                        <div  class="open-button">LEES MEER</div>
                        <div class="read opening-content">
                            <p>
                                Het doel van de app is om VvE’s efficiënter te laten werken. Deze app is de ideale     manier voor een VvE om zich op een toekomstgerichte wijze te onderscheiden. Berichten en meldingen die direct bij de bewoners binnen komen, geen ongelezen emails meer en kortere lijnen in de dagelijkse communicatie. Tevens bevordert de app een hechtere gemeenschap en de veiligheid. Dit allemaal met meer wooncomfort als doelstelling.
                            </p>
                            <div class="close-button">Inklappen</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <section class="space light-bg">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <div class="phone-four">
                        <h2 class="space-item">De belangrijkste zaken <br/>
                            binnen handbereik</h2>
                        <div class="row checks">
                            <div class="col-md-6">
                                <p><i class="material-icons">check_circle</i> Pushberichten</p>
                                <p><i class="material-icons">check_circle</i> Chat</p>
                                <p><i class="material-icons">check_circle</i> Documentenbeheer</p>
                            </div>
                            <div class="col-md-6">
                                <p><i class="material-icons">check_circle</i> Kalender</p>
                                <p><i class="material-icons">check_circle</i> Prikbord</p>
                                <p><i class="material-icons">check_circle</i> Reparatieverzoeken</p>
                            </div>
                        </div>
                        <div class="description-part  read-more d-md-block d-none">
                            <p>
                                Communicatie tussen het bestuur van VvE’s en VvE leden loopt nu vaak stroef. Vaak weten bewoners niet bij wie zij terecht moeten met hun (aan)vragen tot frustratie van alle betrokken partijen.
                            </p>
                            <div class="open-button">LEES MEER</div>
                            <div class="opening-content read">
                                <p>
                                    Ook is er geen communicatiemiddel die bewoners direct met elkaar verbindt op elk gewenst moment van de dag. Een mobiele applicatie is vandaag de dag de meest effectieve manier om bewoners direct te bereiken. Op elk gewenste moment van de dag, waar dan ook te wereld, altijd binnen handbereik met onze moderne VvE Software speciaal voor smartphone en tablet.
                                </p>
                                <div class="close-button">Inklappen</div>
                            </div>
                        </div>
                        <div class="btn-demo  d-md-block d-none">
                            <a href="/demo" class="goto-button grey">BEKIJK DEMO</a>
                        </div>
                    </div>

                </div>
                <div class="col-md-4">
                    <img class="iphone lazy" data-src="/img/home/phone.png"  alt="phone">
                </div>
                <div class="col-12  d-md-none d-block">
                    <div class="phone-four">
                        <div class="description-part read-more">
                            <p>
                                Communicatie tussen het bestuur van VvE’s en VvE leden loopt nu vaak stroef. Vaak weten bewoners niet bij wie zij terecht moeten met
                            </p>
                            <div class="open-button">LEES MEER <i></i></div>
                            <div class="opening-content read">
                                <p>
                                    Communicatie tussen het bestuur van VvE’s en VvE leden loopt nu vaak stroef. Vaak weten bewoners niet bij wie zij terecht moeten met hun (aan)vragen tot frustratie van alle betrokken partijen. Ook is er geen communicatiemiddel die bewoners direct met elkaar verbindt op elk gewenst moment van de dag. Een mobiele applicatie is vandaag de dag de meest effectieve manier om bewoners direct te bereiken. Op elk gewenste moment van de dag, waar dan ook te wereld, altijd binnen handbereik met onze moderne VvE Software speciaal voor smartphone en tablet.
                                </p>
                                <div class="close-button">Inklappen <i></i></div>
                            </div>
                        </div>
                        <div class="btn-demo">
                            <a href="/demo" class="goto-button grey">BEKIJK DEMO</a>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>
    <section class="space software-section">
        <div class="container"><div class="title-middle">
                <h2 class="space-item">VvE Software</h2>
                <p>Voor bestuurders en beheerders van VvE’s hebben we software op maat gemaakt, voor dagelijks beheer van een vereniging.</p>
            </div>
            <div class="row pos-lap d-md-flex d-none">
                @foreach($softwareCards as $i => $card)
                    <div class="col-md-4">
                        <div>
                            <div class="adv">
                                <div>
                                    <img class="lazy" data-src="{{$card["img"]}}" alt="software icon">
                                    <p>{{$card["name"]}}</p>
                                    <a class="goto-button {{$i === 2 ? "yellow" : "grey"}}" href="{{$card["link"]}}">{{$card["button"]}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="midl-sec">
                        <div class="brd-cp"></div>
                        <img class="lazy" data-src="/img/shared/dashboard-new-version.png" alt="laptop dashboard">
                    </div>
                </div>
            </div>
        </div>
        <div class="swiper-container d-md-none">
            <div class="swiper-wrapper">
                @foreach($softwareCards as $i => $card)
                    <div class="swiper-slide">
                        <div class="adv">
                            <div>
                                <img class="lazy" data-src="{{$card["img"]}}" alt="">
                                <p>{{$card["name"]}}</p>
                                <a class="goto-button {{$i === 2 ? "yellow" : "grey"}}" href="{{$card["link"]}}">{{$card["button"]}}</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>


    </section>
    <section class="space light-bg count-section">

        <div class="container">
            <h2>Dé oplossing voor de meest voorkomende <br/> problemen van VvE leden</h2>
            <div class="row d-md-flex d-none">
                @foreach($countCards as $card)
                    <div class="col-md-4">
                        <div class="count-card">
                            <div class="upper">
                                <img data-src="{{$card["img"]}}" class="lazy" alt="count icon"/>
                                <span class="percent">{{$card["count"]}}</span>
                            </div>
                            <p>{{$card["description"]}}</p>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
        <div class="swiper-container d-md-none">
            <div class="swiper-wrapper">
                @foreach($countCards as $card)
                    <div class="swiper-slide">
                        <div class="count-card">
                            <div class="upper">
                                <img data-src="{{$card["img"]}}" class="lazy" alt="count icon"/>
                                <span class="percent">{{$card["count"]}}</span>
                            </div>
                            <p>{{$card["description"]}}</p>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>

        <div class="container">
            <p class="notice" style="font-style: italic">* Deze informatie is verzameld middels ca. 500 mondelinge interviews in opdracht van Appartement</p>
        </div>


    </section>
    <section class="foot quotes space">
        <div class="container">
            {{--            <img class="left-cloud" src="/img/new/Group%2015708.png" alt="clouds">--}}
            {{--            <img class="right-cloud" src="/img/new/Group%2015708.png" alt="clouds" style="transform: scaleX(-1);">--}}
            <h2 class="space-item">Ervaringen</h2>
            <div class="row d-md-flex d-none">
                @foreach($quoteCards as $card)
                    <div class="col-md-4">
                        <div class=" card-foot quote-item">
                            <p class="card-txt">
                                {{$card["content"]}}
                            </p>
                            <div class="card-box">
                                <div></div>
                                <div class="name">{{$card["name"]}}</div>
                                <p>{{$card["location"]}}</p>
                            </div>
                            <img src="/img/home/quote-under.png" alt="pointer" class="quote-under"/>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="swiper-container d-md-none">
            <div class="swiper-wrapper">
                @foreach($quoteCards as $card)
                    <div class="swiper-slide">
                        <div class=" card-foot quote-item">
                            <p class="card-txt">
                                {{$card["content"]}}
                            </p>
                            <div class="card-box">
                                <div></div>
                                <div class="name">{{$card["name"]}}</div>
                                <p>{{$card["location"]}}</p>
                            </div>
                            <img src="/img/home/quote-under.png" alt="pointer" class="quote-under"/>
                        </div>
                    </div>
                @endforeach

            </div>
            <div class="swiper-pagination"></div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>

    </section>

@stop
