@extends("layouts.site", ["headerColor" => "dark"])

@section("title", "VvE App (Best getest 2020) VvE Software + Mobiele App")
@section("description", "Dé VvE App. De moderne VvE software waarmee u uw VvE leden (sneller, gemakkelijker en efficiënter) bereikt. Met de ´Appartement´ App garanderen wij korte lijnen tussen het bestuur en de bewoners via een smartphone of tablet. Als best getest door VvE bewoners.")
@section("keywords", "vve app")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/home.css')}}" />
@stop

@section("after_js")

@stop

@php
    $dis1 = ["Ongelezen mails en briefjes", "Omslachtige en ouderwetse communicatie", "Huidige software is niet gebruiksvriendelijk", "Tijdrovend en zorgt voor geldverspilling",
    "Bestuurders, beheerders en bewoners raken gefrustreerd", "Bewoners maken geen gebruik van bestaande gebruiksonvriendelijke oplossingen"];
    $dis2 = ["Geen mobiele app", "Niet intuitief", "Niet gebruiksvriendelijk", "Niet flexibel", "Niet compleet", "Geen beheerders portaal", "Geen integratie mogelijkheden", "Geen White label"];
    $reachNegative = ["Geen fysieke stemmingen meer", "Geen losse briefjes", "Geen dubbele meldingen", "Geen vergeten afspraken",
    "Geen omslachtige communicatie", "Geen onveilige oplossingen", "Geen frustratie"];
    $reachPositive = ["Prikbord", "Reparatieverzoeken", "Documentenbeheer", "Pushberichten", "Chat", "Stemmen", "Nieuwsbrief"];
@endphp

@section("content")
    <div class="home-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-7">
                    <h1>Bereik uw VvE leden sneller, gemakkelijker en efficiënter met de Appartement App. Bespaar tijd, geld en frustratie.</h1>
                    <a href="/demo" class="goto-button">Bekijk demo</a>
                    <div class="links">
                        @component("components.store-links")
                            @slot("white", true)
                        @endcomponent
                    </div>
                </div>
                <div class="col-lg-6 col-md-5">
                    <img class="img" src="/img/home/phones.png"/>
                </div>
            </div>
        </div>
        <img class="buildings" src="/img/shared/city-white.png" />

    </div>
    <section class="honestly">
        <div class="container">
            <h2>Laten we eerlijk zijn. Is de huidige manier de beste wijze om een gebouw te besturen en te beheren?</h2>
            <p class="subtitle">
                Traditioneel beheren kost veel tijd, geld en zorgt voor frustratie.
            </p>
            <div class="cards">
                <div class="card">
                    <div class="upper">Bekende problemen met traditioneel besturen en beheren</div>
                    <div class="content">
                        <ul>
                            @foreach($dis1 as $item)
                                <li><i class="material-icons">close</i> {{$item}}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="card">
                    <div class="upper">Andere oplossingen zijn niet compleet of niet gebruiksvriendelijk</div>
                    <div class="content">
                        <ul>
                            @foreach($dis2 as $item)
                                <li><i class="material-icons">close</i> {{$item}}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="reach">
        <div class="container">
            <h2>Wat als er een manier was om uw VvE leden sneller, makkelijker en efficiënter te bereiken? </h2>
            <div class="row">
                <div class="col-xl-4 col-lg-6 col-md-7 order-xl-1 order-2">
                    <ul class="negative">
                        @foreach($reachNegative as $item)
                            <li><i class="material-icons">close</i> {{$item}}</li>
                        @endforeach
                    </ul>
                </div>
                <div class="col-xl-4 order-1">
                    <div class="phone-wrapper">
                        <img src="/img/home/avg-logo.svg" class="badge"/>
                        <img src="/img/home/phone.png" class="phone"/>

                    </div>
                    <div class="developed">
                        Developed for: <img src="/img/home/apple.svg"> <span>iOS</span>
                        <div></div> <img src="/img/home/android.svg"> <span>Android</span>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-5 order-xl-1 order-2">
                    <ul class="positive">
                        @foreach($reachPositive as $item)
                            <li><i class="material-icons">check_circle</i> {{$item}}</li>
                        @endforeach
                    </ul>
                    <div class="more">En nog veel meer..</div>
                </div>
            </div>
        </div>

    </section>
    <div class="container">
        <div class="recommend-logos">
            <div>Dé app voor VvE Nederland, aanbevolen door:</div>
            <img src="/img/home/zomer-logo.png"/>
            <img src="/img/home/ibotec-logo.png"/>
            <img src="/img/home/vastion-logo.png"/>
            <img src="/img/home/eharo-logo.png"/>
        </div>
        <div class="functions">
            <div class="upper">Alle functies op een rij</div>
            <div class="middle">
                <div class="function desktop">
                    <div class="img"><img src="/img/home/function-1.png"/></div>
                    <div class="data">
                        <h2>Gemakkelijk beheren</h2>
                        <p>
                            Maak prikbordberichten aan, beheer reparatieverzoeken,
                            verstuur push notificaties naar alle leden, maak stemmingen aan, post nieuwsberichten en nog veel meer.
                        </p>
                        <ul>
                            <li>Gemakkelijk beheren, aanmaken en wijzigen in het VvE Portaal</li>
                            <li>Ook functies voor leden die geen App willen/kunnen gebruiken</li>
                            <li>Ideaal voor bestuurders en beheerders</li>
                            <li>Voor PC/Laptop</li>
                            <li>Continu geupdate </li>
                        </ul>
                        <a href="/demo" class="goto-button">Bekijk demo</a>
                    </div>
                </div>
                <div class="function mobile">
                    <div class="img"><img src="/img/home/function-2.png"/></div>
                    <div class="data">
                        <h2>Directe communicatie</h2>
                        <p>
                            Snelle en directe communicatie met alle leden, bestuurders en beheerders. Via de app dus altijd binnen handbereik.
                        </p>
                        <ul>
                            <li>Chatfunctie</li>
                            <li>Pushberichten</li>
                            <li>Prikbord</li>
                            <li>Nieuwsbrief</li>
                            <li>Voor iOS en Android toestellen</li>
                        </ul>
                        <a href="/demo" class="goto-button">Bekijk demo</a>
                    </div>
                </div>
                <div class="function mobile">
                    <div class="img"><img src="/img/home/function-3.png"/></div>
                    <div class="data">
                        <h2>Digitaal stemmen</h2>
                        <p>
                            Op afstand stemmen over belangrijke zaken binnen de VvE via de app.
                        </p>
                        <ul>
                            <li>Volledig rechtsgeldig</li>
                            <li>Digitale ondertekening</li>
                            <li>Geheel naar wens in te stellen</li>
                            <li>Verdeling op basis van 1 stem of appartementsrechten</li>
                            <li>Handig dashboard met uitkomsten in grafieken</li>
                            <li>Machtiging verlenen via de app</li>
                        </ul>
                        <a href="/demo" class="goto-button">Bekijk demo</a>
                    </div>
                </div>
                <div class="function mobile">
                    <div class="img"><img src="/img/home/function-4.png"/></div>
                    <div class="data">
                        <h2>Reparatieverzoeken</h2>
                        <p>
                            Bekijk en beheer ontvangen reparatieverzoeken. Automatisch doorgestuurd naar de juiste persoon.
                        </p>
                        <ul>
                            <li>Gemakkelijk beheren in het VvE Portaal</li>
                            <li>Alle onderdelen voorgeprogrammeerd</li>
                            <li>Status kan gemakkelijk gewijzigd worden</li>
                            <li>Geen dubbele meldingen meer</li>
                            <li>Bespaart veel tijd en frustratie</li>
                        </ul>
                        <a href="/demo" class="goto-button">Bekijk demo</a>
                    </div>
                </div>
                <div class="function mobile">
                    <div class="img"><img src="/img/home/function-5.png"/></div>
                    <div class="data">
                        <h2>Kalender</h2>
                        <p>
                            Voeg belangrijke zaken toe aan de kalender zodat alle leden op de hoogte blijven van belangrijke gebeurtenissen.
                        </p>
                        <ul>
                            <li>Voeg vergaderingen en andere belangrijke zaken toe</li>
                            <li>Synchronisatie met eigen kalender op smartphone</li>
                            <li>Geen vergeten afspraken meer</li>
                        </ul>
                        <a href="/demo" class="goto-button">Bekijk demo</a>
                    </div>
                </div>
                <div class="function mobile">
                    <div class="img"><img src="/img/home/function-6.png"/></div>
                    <div class="data">
                        <h2>Documentbeheer</h2>
                        <p>
                            Voeg documenten toe zodat bestuurders, beheerders en leden toegang hebben binnen een paar tellen.
                        </p>
                        <ul>
                            <li>Voeg huishoudelijke reglementen, splitsingsaktes en nog veel meer toe</li>
                            <li>Beheer gemakkelijk wie toegang heeft tot welk document</li>
                            <li>Speciale sectie met alleen toegang voor bestuurders</li>
                        </ul>
                        <a href="/demo" class="goto-button">Bekijk demo</a>
                    </div>
                </div>
            </div>
            <div class="lower">
                <h2>Onze gebruikers ervaren dagelijks de voordelen, blijf niet achter</h2>
                <ul>
                    <li>Gemiddeld 48% tijd/handelings besparing</li>
                    <li>30 dagen GRATIS en vrijblijvend uitproberen</li>
                    <li>Ontvang ondersteuning en advies</li>
                </ul>
                <a href="/30-day-trial" class="goto-button">30 dagen GRATIS uitproberen</a>
            </div>
        </div>
        <div class="need-help">
            <h2>De Appartement App en VvE portaal zijn gemakkelijk te gebruiken.</h2>
            <div class="card">
                <img src="/img/home/help-icon.svg"/>
                <span>
                    <div>En als u ooit hulp nodig heeft?</div>
                    We hebben een deskundig team beschikbaar voor al uw vragen - inbegrepen in het abonnement.
                </span>
            </div>
        </div>
        <div class="why-us">
            <h2>Waarom appartement?</h2>
            <div class="row">
                <div class="item">
                    <img src="/img/home/why-communicate.svg"/>
                    <span>Korte lijnen tussen VvE’s en leden</span>
                </div>
                <div class="item">
                    <img src="/img/home/why-reach.svg"/>
                    <span>Gratis te downloaden voor bewoners</span>
                </div>
                <div class="item">
                    <img src="/img/home/why-modern.svg"/>
                    <span>Modern en professioneel</span>
                </div>
                <div class="item">
                    <img src="/img/home/why-shield.svg"/>
                    <span>Verhoogt de veiligheid van de gemeenschap</span>
                </div>
                <div class="item">
                    <img src="/img/home/why-frustration.svg"/>
                    <span>Vermindert frustratie voor alle partijen</span>
                </div>
                <div class="item">
                    <img src="/img/home/why-climate.svg"/>
                    <span>Beter voor het klimaat door minder te printen</span>
                </div>
            </div>
        </div>
    </div>
    @include("partials/stats")
    <section class="experiences">
        <div class="container">
            <h2>Ervaringen</h2>
            <div class="card">
                <div class="upper"><span>Willem</span> - VvE, Amsterdam</div>
                <p>‘Sinds het gebruik van de app hebben wij geen vervelende dubbele meldingen meer. ’</p>
            </div>
            <div class="card">
                <div class="upper"><span>Mariska</span> - VvE, Den haag</div>
                <p>‘Typisch een product dat je eerder had moeten hebben. Onze leden zijn er erg blij mee. We hebben een stuk minder ergernissen. Ook de leden die het in eerste instantie niet wilden gebruiken zijn nu om’</p>
            </div>
            <div class="card">
                <div class="upper"><span>Piet</span> - VvE, Alphen aan den Rijn</div>
                <p>'De app is fantastisch. Wij gebruiken de app dagelijks en het heeft ons leven een stuk makkelijk gemaakt!’</p>
            </div>
        </div>

    </section>
@stop
