<!DOCTYPE html>
<html lang="en">
<head>
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-132454035-1"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'UA-132454035-1');
    </script>
    <script>
        (function(h,o,t,j,a,r){
            h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
            h._hjSettings={hjid:1803633,hjsv:6};
            a=o.getElementsByTagName('head')[0];
            r=o.createElement('script');r.async=1;
            r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
            a.appendChild(r);
        })(window,document,'https://static.hotjar.com/c/hotjar-','.js?sv=');
    </script>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <link rel="icon" type="image/x-icon" href="/favicon/favicon.ico">

    <title>@yield('title')</title>
    <meta name="description" content="@yield("description")">
    <meta name="keywords" content="@yield("keywords")">

    <link rel="canonical" href="https://www.app-artement.nl/">

    <meta property="og:locale" content="nl_NL">
    <meta property="og:type" content="website">
    <meta property="og:title" content="@yield('title')">
    <meta property="og:description" content="@yield("description")">
    <meta property="og:url" content="https://www.app-artement.nl/">
    <meta property="og:site_name" content="Appartement">

    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="@yield("title")">
    <meta name="twitter:description" content="@yield("description")">

    <meta name="theme-color" content="#F15A4D">
    <link rel="manifest" href="/manifest.json">
    <link rel="apple-touch-icon" sizes="57x57" href="/favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="/favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="/favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="/favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="/favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="/favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="/favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="/favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="/favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="/favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="512x512"  href="/favicon/android-icon-512x512.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="/favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon/favicon-16x16.png">
    <meta name="msapplication-TileColor" content="#ECF1F5">
    <meta name="msapplication-TileImage" content="/favicon/ms-icon-144x144.png">
    <link rel="stylesheet" href="{{mix('/css/app.css')}}" type="text/css">

    @yield("after_css")

</head>
<body>

@include("partials/header", ["headerColor" => isset($headerColor) ? $headerColor : null])

@yield('content')

@include("partials/footer")

<div id="cookie-contest" style="display: none">
    <div>
        <p>
            Appartement gebruikt cookies voor analyse, het goed functioneren en persoonlijker maken van de website.
            Ook worden cookies ingezet om buiten <a href="https://app-artement.nl">app-artement.nl</a> relevante advertenties te kunnen tonen.
            Door verder gebruik te maken van de website gaat u akkoord met de plaatsing van de cookies.
        </p>
        <span><button>Accepteren</button></span>
    </div>
</div>

<noscript id="deferred-styles">
    <link href='https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600,bold' rel='stylesheet' type="text/css">
    <link href='/css/fonts.css' rel='stylesheet' type="text/css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons" type="text/css">
</noscript>

@if(isset($useJquery) && $useJquery)
    <script src="https://code.jquery.com/jquery-3.4.1.min.js" type="text/javascript"></script>
@endif
<script src="/js/polyfills.js" type="text/javascript"></script>
<script>
    var fullMenu = document.querySelector('.full-menu');

    document.querySelector('#menu-button').addEventListener('click', function () {
        fullMenu.classList.add('active');
        document.body.style.overflow = "hidden";
    });
    document.querySelector('#menu-button-close').addEventListener('click', function () {
        fullMenu.classList.remove('active');
        document.body.style.overflow = "";
    });

    function getCookie(name) {
        var value = "; " + document.cookie;
        var parts = value.split("; " + name + "=");
        if (parts.length == 2) return parts.pop().split(";").shift();
    }
    if (getCookie('cookie_agreement') != 'true'){

        var cookieContainer = document.getElementById("cookie-contest");
        cookieContainer.style.display = 'block';
        cookieContainer.getElementsByTagName('button')[0].addEventListener('click',function(){
            var date = new Date();
            date.setTime(+ date + (365 * 86400000)); //24 * 60 * 60 * 1000

            document.cookie = "cookie_agreement=true; expires=" + date.toGMTString() + "; path=/";
            cookieContainer.style.display = 'none';
        });
    }

</script>
@yield("after_js")

</body>
</html>
