@extends("layouts.site")

@section("title", "Wie zijn wij en waarom hebben wij de Appartement App ontwikkeld?")
@section("description", "De Appartement App is ontstaan vanuit een behoefte. Bekijk de voordelen voor bewoners en bestuurders en overtuig uzelf met de geboekte resultaten van andere VvE’s.")
@section("keywords", "Over appartement")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/over-ons.css')}}">
@stop

@section("after_js")
    <script>
        function btn_less(){
            document.getElementById('leesBtn').style.display='none'
        }

        function btn_ink(){
            document.getElementById('leesBtn').style.display='inline-block'
        }
        function leesMeer(){
            document.getElementById('leesMeerBtn').style.display='none';
            document.getElementById('p-lees').style.display='none'
        }
        function inklappen(){
            document.getElementById('leesMeerBtn').style.display='inline-block';
            document.getElementById('p-lees').style.display='block'
        }
    </script>
    <script>
        var descriptionParts = document.querySelectorAll('.description-part');

        descriptionParts.forEach(function(part){
            var openBtn = part.querySelector('.open-button');
            var closeBtn = part.querySelector('.close-button');
            if(openBtn && closeBtn){
                openBtn.addEventListener("click",function(){
                    part.classList.add('opened');
                    scrollToElement(part, 400, 80)
                });
                closeBtn.addEventListener("click",function(){
                    part.classList.remove('opened');

                    scrollToElement(part, 400, 80)
                });
            }

        });
    </script>
@stop

@php
    $needs = [
        [
            "title" => "Slechte bereikbaarheid",
            "img" => "/img/about-us/icon-chat.svg",
            "description" => "Slechte bereikbaarheid van bestuurders"
        ],  [
            "title" => "Slechte vindbaarheid",
            "img" => "/img/about-us/icon-magnifier.svg",
            "description" => "Slechte vindbaarheid van documenten zoals de huishoudelijke reglementen"
        ],  [
            "title" => "Omslachtig met verzoeken",
            "img" => "/img/about-us/icon-send.svg",
            "description" => "Doorgeven van (reparatie)verzoeken omslachtig"
        ]
    ];

    $reasons = [
        [
            "img" => "/img/home/slide-communication.png",
            "text" => "Korte lijnen tussen VvE’s en leden"
        ],   [
            "img" => "/img/home/slide-reach.png",
            "text" => "Gratis te downloaden voor bewoners"
        ],   [
            "img" => "/img/about-us/icon-interface.svg",
            "text" => "Niet meer ouderwets beheren en communiceren"
        ],  [
            "img" => "/img/home/slide-shield.png",
            "text" => "Verhoogt de veiligheid van de gemeenschap"
        ],  [
            "img" => "/img/about-us/icon-face.svg",
            "text" => "Vermindert frustratie voor alle partijen"
        ], [
            "img" => "/img/about-us/icon-heart.svg",
            "text" => "Beter voor het klimaat door minder te printen"
        ]
    ];
@endphp

@section("content")


    <section>
        <div class="box-orange box-blue  box-txt-orange">
            <img class="mob-size" src="/img/shared/clouds-white.svg" alt="">
            <img class=" bulding-svg" src="/img/shared/city-white.svg" alt="">
            <img class="mob-size-city" src="/img/shared/buildings-white.svg" alt="">
            <div class="container">
                <h1>Over Appartement</h1>
                <p>Alles onder één dak</p>
            </div>
        </div>
    </section>
    <section class="content-over">
        <div class="container">
            <div class="row">
                <div class="col-xl-3">
                    <div class="txt-content">
                        <div>Appartement is ontstaan vanuit een behoefte</div>
                        <div>Voornamelijk door frustratie vanwege:</div>
                    </div>
                </div>
                @foreach($needs as $need)
                <div class="col-xl-3 col-md-4 col-12">
                    <div class="col-content">
                        <div class="img">
                            <img src="/img/about-us/emote-bad.svg" alt="stress">
                            <img src="{{$need["img"]}}">
                        </div>
                        <span>{{$need["title"]}}</span>
                        <div class="p-col">{{$need["description"]}}</div>
                    </div>
                </div>
                @endforeach
            </div>
            <hr>
            <div class="row row-content">
                <div class="col-xl-4 col-8">
                    <div class="col-img">
                        <img src="/img/about-us/devices.png" alt="">
                        @component("components.store-links")
                            @slot("hideAvg", true)
                        @endcomponent
                    </div>
                </div>
                <div class="col-xl-8 col-10 col-p">
                    <p>Appartement is <strong>de enige partij op de Nederlandse markt</strong> , die software speciaal heeft ontwikkeld voor bestuurders, beheerders en leden van een VvE. De App voor iOS en Android smartphones en tablets, verbindt het bestuur met de bewoners van een VvE.</p>
                </div>
            </div>
        </div>
    </section>
    <section class="phone bg-light">
        <div class="container">
            <div class="row row-phone">
                <div class="col-md-6">
                    <img src="/img/about-us/phone-half.png" alt="" width="285px">
                </div>
                <div class="col-md-6">
                    <div class="phone-four">
                        <div class="txt-mob">De functies voor VvE leden</div>
                        <div class="p-phone">Leden van een VvE kunnen gebruik maken van de App met o.a. de volgende functies:  </div>
                        <div class="row checks">
                            <div class="col-md-6 col-sm-6">
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Documenten inzien	</div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Prikbord	</div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Ontvangen van Pushberichten</div></div>
                            </div>
                            <div class="col-md-6 col-sm-6">
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Kalender</div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Chat</div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Reparatieverzoeken indienen</div></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="space read-page ">
        <div class="container">
            <div class="row">
                <div class="col-md-6">

                    <div class="phone-four">
                        <div class="txt-mob">De functies voor VvE bestuurders en beheerders</div>
                        <div class="p-phone">Bestuurders en beheerders van een VvE beschikken over de app en de Admin portal met o.a. de volgende functies:</div>
                        <div class="row checks">
                            <div class="col-md-6 col-sm-6">
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Pushberichten versturen    </div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Documentenbeheer	</div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div class="p-check"> Prikbordbeheer</div></div>
                            </div>
                            <div class="col-md-6 col-sm-6">
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Chat</div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div> Kalenderbeheer</div></div>
                                <div class="prij-check"><i class="material-icons">check_circle</i><div class="word-prij"> Reparatieverzoekbeheer</div></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <img class="img-desk" src="/img/demo/vve-overzicht-1.png" alt="">
                </div>
            </div>
            <hr>
            <div class="description-part  read-more">
                <p>
                    VvE’s zijn digitaal gezien vrij conservatief waardoor er veel ruimte is voor innovatie.
                    Daar wil Appartement verandering in brengen.
                    Het doel van de app is om VvE’s efficiënter te laten opereren.
                    Deze app is de ideale manier voor een VvE om zich op een toekomstgerichte wijze te onderscheiden.
                </p>
                <div class=" open-button">Lees meer</div>
                <div class="opening-content">
                    <p >
                        Leden en bestuurders kunnen elkaar direct en gemakkelijk bereiken. Reparatieverzoeken komen bij de juiste personen terecht.
                        Alle belangrijke documenten kunnen binnen een paar tellen worden ingezien.
                        En dit is slechts een kleine greep van mogelijkheden. Kortom, korte lijnen, alle informatie op één plek en altijd binnen handbereik.
                        Dit op een wijze die bij deze tijd past met meer wooncomfort als streven.
                    </p>
                    <div class="close-button">Inklappen</div>
                </div>
            </div>
        </div>
    </section>
    <section class="bg-light why-section space">
        <div class="container">
            <div class="title space-item">
                Waarom Appartement?
            </div>
            <div class="row">
                @foreach($reasons as $reason)
                    <div class="col-lg-4 col-md-6">
                        <div class="item">
                            <img src="{{$reason["img"]}}"/>
                            <div>
                                {{$reason["text"]}}
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    @include("/partials/stats")
@stop
