@extends("layouts.site", ["useJquery" => true])

@section("title", "Bekijk hier de verschillende pakketten van de VvE app. Vraag direct een informatiepakket inclusief prijzen op.")
@section("description", "De Appartement VvE app heeft voor iedere organisatie het juiste pakket. Kies het juiste pakket en test deze 30 dagen geheel vrijblijvend. ")
@section("keywords", "vve app prijzen")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/prijzen-2.css')}}"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
@stop



@section("after_js")
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script src="/js/jquery.validate.min.js"></script>
    <script type="text/javascript">
        $.validator.addMethod("count", function(value, element) {
            if(!value) return true;
            var n = parseInt(element.value);
            if(!isNaN(n) && n > 0){
                element.value = n;
                return true;
            }
            return false;
        }, "Vul a.u.b. gehele getallen in");

        $.validator.addMethod("houseNumber", function(value, element){
            value = value.split(" ").join("");
            var regExp = new RegExp('^[0-9]{3,4}[A-Za-z]{1,2}$');
            return regExp.test(value);
        }, "");
        $.validator.addMethod("postCode", function(value, element){
            value = value.split(" ").join("");
            var regExp = new RegExp('^[0-9]{4}[A-Za-z]{2}$');
            return regExp.test(value);
        }, "");
        $.validator.addMethod(
            "regex",
            function(value, element, regexp) {
                var re = new RegExp(regexp);
                return this.optional(element) || re.test(value);
            }
        );

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.fn.serializeFormJSON = function () {

            var o = {};
            var a = this.serializeArray();
            $.each(a, function () {
                if (o[this.name]) {
                    if (!o[this.name].push) {
                        o[this.name] = [o[this.name]];
                    }
                    o[this.name].push(this.value || '');
                } else {
                    o[this.name] = this.value || '';
                }
            });
            return o;
        };


        $( document ).ready( function () {

            var validation = $( "#form" ).validate( {
                onfocusout: function(element) {
                    $(element).valid();
                },
                rules: {
                    firstName: "required",
                    lastName: "required",
                    CompanyName: "required",
                    email: {
                        required: true,
                        email: true
                    },
                    phone: {
                        required:true,
                        minlength: 10
                    },
                    houseNumber: {
                        required: true
                    },
                    postalCode:{
                        postCode: true
                    },
                    street: {
                        required: true
                    },
                    city: {
                        required: true
                    },
                    vveCount: {
                        count: true
                    },
                },
                messages: {
                    firstName: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. jouw voornaam in.</p>",
                    lastName: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'>Voer hier a.u.b. jouw achternaam in.</p>",
                    companyName: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. de naam van de VvE in.</p>",
                    email: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldig e-mailadres in (bijv. mail@voorbeeld.nl)</p>",
                    phone: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier alleen getallen in zonder streepje</p>",
                    houseNumber: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldig huisnummer in</p>",
                    postalCode: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldige postcode in</p>",
                    street: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. een geldige straatnaam in</p>",
                    city: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Voer hier a.u.b. de stad in</p>",
                    vveCount: "<p class='aantal'><img src='/img/icons/Icon-material-error.png'> Geef het aantal op a.u.b</p>"
                },
                errorElement: "em",
                errorPlacement: function ( error, element ) {
                    // Add the `invalid-feedback` class to the error element
                    error.addClass( "invalid-feedback" );

                    if ( element.prop( "type" ) === "checkbox" ) {
                        error.insertAfter( element.next( "label" ) );
                    } else {
                        error.insertAfter( element );
                    }
                },
                highlight: function ( element, errorClass, validClass ) {
                    $( element ).addClass( "is-invalid" ).removeClass( "is-valid" );
                    element.parentElement.classList.remove("parent-valid");
                },
                unhighlight: function (element, errorClass, validClass) {
                    $( element ).addClass( "is-valid" ).removeClass( "is-invalid" );
                    element.parentElement.classList.add("parent-valid");
                },
                submitHandler: function(form){
                    var data = $(form).serializeFormJSON();


                    Swal.fire({
                        title: "Even geduld a.u.b.",
                        allowEscapeKey: false,
                        allowOutsideClick: false,
                        onOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    $.post({
                        url: "/api/form/pricing",
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                        data: data,
                        success: (result)=>{
                            // Swal.fire({
                            //     icon: 'success',
                            //     title: 'Form submitted',
                            //     onClose: ()=>{
                            //         location.href = "/bedankt";
                            //     }
                            // })
                            location.href = "/bedankt";
                        },
                        dataType: "json",
                        error: (err)=> {
                            var errors = "";
                            for (let key in err.responseJSON.errors) {
                                errors += err.responseJSON.errors[key] + "<br/>"
                            }

                            var title = "Dit veld is niet correct ingevuld";
                            if(err.responseJSON.message && !err.responseJSON.message.includes("was invalid")){
                                title = err.responseJSON.message
                            }

                            Swal.fire({
                                icon: "error",
                                title: title,
                                html: errors
                            })
                        }
                    });


                    return false

                }

            } );


            $( "#form input" ).on( "input", function( e ) {

                    validation.element(e.target);

                }
            );


        } );

        var tabButtons = document.querySelectorAll(".tabs button");


        function activateTab(num){
            var toActive =  document.querySelector("div.tab-data:nth-of-type(" + num + ")");
            toActive.classList.add("active");
        }

        activateTab(1);

        for (var i = 0; i < tabButtons.length; i++) {

            tabButtons[i].addEventListener("click", function () {
                document.querySelector(".tabs button.active").classList.remove("active");
                this.classList.add("active");
                document.querySelector(".tab-data.active").classList.remove("active");
                activateTab(this.getAttribute("data-active"))
            })
        }



    </script>
@stop

@section("content")

    <section>
        <div class="box-orange">
            <img class="mob-size" src="/img/shared/clouds-white.svg" alt="">
            <img class="bulding-svg" src="/img/shared/city-white.svg" alt="">
            <img class="mob-size-city" src="/img/shared/buildings-white.svg" alt="">
            <div>
                <div class="container">
                    <div class="txt-prij">
                        <h1>Prijzen</h1>
                        <p>Bekijk de prijzen, alles onder één dak</p>
                    </div>
                </div>
                <div class="container tabs-container">
                    <div class="tabs">
                        <button data-active="1" class="active">VvE bestuurders</button>
                        <button data-active="2">VvE beheerders</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="container prijzen-page">
            <div class="tab-data active">
                <div class="tab-upper">
                    <h2>VvE bestuurders</h2>
                    <p>Bent u als bestuurslid van een VvE op zoek naar een snelle en moderne communicatiemiddel? <br/>
                        Met de Appartement App heeft u de meest complete oplossing, speciaal gemaakt voor kleine, middelgrote en grote VvE’s.</p>
                </div>
                <div class="tab-content">
                    <div>
                        <div class="title d-none d-md-block">Actie:</div>
                        <div class="flexed">
                            <div class="first">
                                <div class="title d-block d-md-none">Actie:</div>
                                <div class="couple">
                                    Opstartkosten: <span><b>Tijdelijk GRATIS</b> (t.w.v. € 250,-)</span>
                                </div>
                                <div class="couple">
                                    Inrichting VvE omgeving:  <span><b>Tijdelijk GRATIS</b> (t.w.v. € 180,-)</span>
                                </div>
                                <div class="couple">
                                    Support:   <span><b>Blijvend GRATIS</b></span>
                                </div>
                            </div>
                            <div class="second">
                                <div class="price">
                                    <div>€ 0,40</div> p/m
                                </div>
                                <div class="vat">
                                    *Per appartementsrecht, Excl. BTW <br/>
                                    *Contractduur minimaal 1 jaar
                                </div>
                                <a href="/30-day-trial" class="link-button d-inline-block d-md-none">30 dagen GRATIS uitproberen</a>
                            </div>
                        </div>
                        <div class="flexed-below">
                            <div class="lower">
                                <div>Nr. 1 VvE App</div>
                                Overtuig uzelf en probeer de app nu 30 dagen geheel vrijblijvend
                            </div>
                            <a href="/30-day-trial" class="link-button d-none d-md-inline-block">30 dagen GRATIS uitproberen</a>
                        </div>
                    </div>
                    <div class="check-list">
                        <div class="title">Uw app bevat de volgende functies:</div>
                        @php
                            $list1 = ["Prikbord", "Kalender", "Ledenlijst", "Bestuurderslijst", "Pushberichten", "VvE documenten"];
                            $list2 = ["VvE beheerder informatie", "VvE panel (web app)", "PDF aanmaken voor niet app gebruikers", "Chatfunctie (berichten)",
                                    "Reparatieverzoeken inclusief status wijzigingen", "Rollenverdeling (Bestuur, bewoner, beheerder)"];
                            $list3 = [   "Huishoudelijk reglement", "Huurders functie", "Nieuwsbrief", "Stemmen via de app", "Multi language (NL/EN)", "Logboek"];

                        function getChecksCol($n){
                            if($n%3 === 1){
                                return 3;
                            } else if($n%3 === 2){
                                return 5;
                            }
                            return 4;
                        }
                        @endphp
                        <div class="row">
                            <div class="col-lg-4">
                                @foreach($list1 as $item) <span><img src="/img/icons/green-check.svg"/> {{$item}}</span> @endforeach
                            </div>
                            <div class="col-lg-5">
                                @foreach($list2 as $item) <span><img src="/img/icons/green-check.svg"/> {{$item}}</span> @endforeach
                            </div>
                            <div class="col-lg-3">
                                @foreach($list3 as $item) <span><img src="/img/icons/green-check.svg"/> {{$item}}</span> @endforeach
                            </div>
                        </div>
                    </div>

                </div>
                <div class="security">
                    <div class="title">Uw zekerheden:</div>
                    <div class="lower">
                        <div class="row">
                            <div class="col-lg-4 col-md-5 col-sm-6">
                                <div class="cert">
                                    <span><img src="/img/icons/lock-blue.svg"/> Beveiliging:</span>
                                    <div>AVG Proof <br/>
                                        Onbeperkte dataopslag <br/>
                                        Versleutelde dataopslag <br/>
                                        Dagelijkse back-ups</div>
                                </div>
                                <div class="cert d-block d-md-none">
                                    <span><img src="/img/icons/shield-avg-blue.svg"/> AVG &nbsp;<b> PROOF</b></span>
                                </div>
                            </div>
                            <div class="col-lg-5 col-md-4 col-sm-6">
                                <div class="cert">
                                    <span><img src="/img/icons/cert-blue.svg"/> Certificatie:</span>
                                    <div>ISO 27001:2013 <br/>
                                        ISO 9001:2008 <br/>
                                        ISO 14001:2004 <br/>
                                        PCI – DSS <br/>
                                        SOC 1 Type II (ISAE3402) <br/>
                                        AMS-ix Certified</div>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="cert d-none d-md-block">
                                    <span><img src="/img/icons/shield-avg-blue.svg"/> AVG <b> PROOF</b></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="tab-data">
                <div class="container">
{{--                    <div class="coming-soon">--}}
{{--                        <div>--}}
{{--                            <img src="/img/coming-soon.png" style="max-width: 100%"/>--}}
{{--                        </div>--}}
{{--                        Coming soon--}}
{{--                    </div>--}}

                    <div class="tab-upper">
                        <h2>VvE beheerders</h2>
                        <p>Bent u als beheerder van VvE's op zoek naar een snelle en moderne communicatiemiddel?
                            Met de Appartement App heeft u een complete oplossing die speciaal gemaakt is voor beheerders. De app is ook <a href="/white-label">White Label</a> verkrijgbaar.</p>
                    </div>
                    <div class="row form-row">
                        <div class="col-md-12 offset-sm-2">
                            <form id="form" class="form-horizontal">
                                @csrf
                                <div class="border-bottom">
                                    <div class="form-group row">
                                        <div class="col-md-3">
                                            <label>Aanhef<span>*</span></label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="radio" name="gender" value="1" id="genderMale" checked="checked"> <label for="genderMale" style="margin-right: 14px">Dhr.</label>
                                            <input type="radio" name="gender" value="0" id="genderFemale"> <label for="genderFemale">Mevr.</label>
                                        </div>


                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="firstName">Voornaam<span>*</span></label>

                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="firstName" name="firstName" placeholder="" />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="lastName">Achternaam<span>*</span></label>

                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="lastName" name="lastName" placeholder="" />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="companyName">Bedrijfsnaam<span>*</span></label>
                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="companyName" name="companyName" placeholder="" />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="vveCount">Aantal VvE's</label>
                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="vveCount" name="vveCount" placeholder="" />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-form-label col-lg-3" for="street">Straatnaam<span>*</span></label>
                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="street" name="street"  />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-form-label col-lg-3" for="houseNumber">Huisnummer<span>*</span></label>
                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="houseNumber" name="houseNumber"  />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="postalCode">Postcode<span>*</span></label>
                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="postalCode" name="postalCode" />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="city">Stad<span>*</span></label>
                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="city" name="city" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="email">E-mail<span>*</span></label>
                                    <div class="col-lg-9">
                                        <input type="text" class="form-control" id="email" name="email" placeholder="" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-lg-3 col-form-label" for="phone">Telefoonnummer<span>*</span></label>
                                    <div class="col-lg-9">
                                        <input type="tel" class="form-control" id="phone" name="phone" placeholder="" maxlength="13" />
                                    </div>
                                </div>
                                <div class="form-group form-textarea row">
                                    <label class="col-lg-3 col-form-label" for="comment">Opmerkingen</label>
                                    <div class="col-lg-9">
                                        <textarea name="comment" id="comment"  rows="10"></textarea>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <div class="col-md-9"></div>
                                    <div class="col-md-3">
                                        <button type="submit" class="submit-button goto-button" id="submitBtn">Versturen <span class="ml-2 fa fa-arrow-circle-right"></span></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>



    </section>
@stop
