
@extends("layouts.site", ["useJquery" => true])

@section("title", "VvE software speciaal gemaakt voor VvE Nederland. Uitgebreid, gemakkelijk, intuïtief en toegankelijk.")
@section("description", "VvE software dat speciaal gemaakt is voor VvE’s. Uitgebreide functies. Compleet, betaalbaar en gemaakt in samenwerking met VvE beheerders.")
@section("keywords", "vve software")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/software.css')}}">
@stop


@section("after_js")
    <script>
        function gotoFirst(){
            scrollToElement(document.querySelector(".app-section"), 300, 50)
        }

        function gotoSecond(){
            scrollToElement(document.querySelector(".app-section.light-bg"), 700, 50)
        }
    </script>


@stop

@php

    $data = [
        [
            "name" => "POPULAIRE FUNCTIES",
            "img" => "/img/software/software-config.svg",
            "list" => [
                "Gedetailleerde bouwspecificaties", "Leden- en bestuurslijst beheer", "Kalender evenementen beheer",
                "Reparatieverzoeken beheer", "Nieuwsbrieven aanmaken", "Stemmingen aanmaken"
            ]
        ],  [
            "name" => "VOORDELEN",
            "img" => "/img/software/icon-benefits.svg",
            "list" => [
                  "Sneller en directer communiceren", "Modernere uitstraling van de VvE", "Geen dubbele (reparatie) meldingen meer",
                  "Digitaal stemmen", "Meer betrokkenheid van de leden", "Betere veiligheid van het complex"
            ]
        ]
    ];



    $privateLabel = [
        "Eigen naam voor de app en admin portal", "Eigen app icoon/logo", "Eigen ‘veelgestelde vragen’ en ‘over ons´"
    ];
@endphp

@section("content")
    <section class="section-one light-bg bg-one-section"  id="home">
        <img class="cloud-home" src="/img/cloud-home.png" alt="">
        <div class="container" style="z-index: 2; position: relative">
            <div class="row">
                <div class="col-md-6 order-2 order-md-1">
                    <div class="image-wrapper">
                        <img src="/img/software/desktop-phone.png"/>
                    </div>
                </div>
                <div class="col-md-6 order-1 order-md-2">
                    <div class="content-one">
                        <h1>VvE Software</h1>
                        <p>Onze VvE software is speciaal voor VvE's ontwikkeld. Wijzig belangrijke zaken gemakkelijk en overzichtelijk via de PC, laptop of tablet.</p>
                        <div class="buttons">
                            <button onclick="gotoFirst()" class="goto-button grey icon-down">VVE BESTUURDERS</button>
                            <button onclick="gotoSecond()" class="goto-button grey icon-down">VVE BEHEERDERS</button>
                        </div>


                        <div class="lower-links">
                            @component("components.store-links")@endcomponent
                        </div>

                    </div>

                </div>
            </div>
        </div>
        <img class="appartement-home" src="/img/appartement-home.png" alt="">
    </section>

    <section class="app-section space" id="vve-bestu">
        <div class="container">
            <h2 class="space-item">VvE bestuurders</h2>
            <h3>
                Naast de Appartement App heeft Appartement ook de ‘Admin Portal’. Met de Admin Portal worden belangrijke zaken die zichtbaar worden op de mobiele app, beheerd en ingericht. Hieronder een greep van de mogelijkheden:
            </h3>
            <img class="laptop d-md-none d-block" src="/img/shared/dashboard-new-version.png"/>
            <div class="row">
                @foreach($data as $card)
                <div class="col-md-4">
                    <div class="app-card">
                        <div class="upper">
                            <img src="{{$card["img"]}}"/>
                            <div>{{$card["name"]}}</div>
                        </div>
                        <ul>
                            @foreach($card["list"] as $item)
                            <li><i class="material-icons">check_circle</i> {{$item}}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                @endforeach

                <div class="col-md-4">
                    <div class="app-card yellow">
                        <div class="upper">
                            <img src="/img/home/slide-private-label.png"/>
                            <div>WHITE LABEL?</div>
                        </div>
                        <ul>
                            @foreach($privateLabel as $item)
                                <li><i class="material-icons">check_circle</i> {{$item}}</li>
                            @endforeach
                        </ul>
                        <a class="goto-button grey" href="/white-label">MEER INFORMATIE</a>
                    </div>
                </div>


            </div>
            <div class="brd-cp"></div>
            <img class="laptop d-none d-md-block" src="/img/shared/dashboard-new-version.png"/>
            <div class="lower">
                <p>
                    Ook zijn er handige statistieken te zien via het ‘dashboard’. De functies en dashboard mogelijkheden worden continu uitgebreid. Op deze wijze bespaart uw VvE meer tijd en kosten.
                </p>
                <a class="goto-button" href="/demo">BEKIJK DEMO</a>
            </div>
        </div>
    </section>


    <section class="app-section space light-bg"  id="vve-beheer">
        <div class="container">
            <h2 class="space-item">VvE beheerders</h2>
            <h3>
                Voor VvE beheerders heeft de Appartement ‘admin panel’’ extra mogelijkheden los van onderstaande functies.
            </h3>
            <img class="laptop d-md-none d-block" src="/img/shared/dashboard-new-beheer.png"/>
            <div class="row">
                @foreach($data as $card)
                    <div class="col-md-4">
                        <div class="app-card">
                            <div class="upper">
                                <img src="{{$card["img"]}}"/>
                                <div>{{$card["name"]}}</div>
                            </div>
                            <ul>
                                @foreach($card["list"] as $item)
                                    <li><i class="material-icons">check_circle</i> {{$item}}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                @endforeach

                <div class="col-md-4">
                    <div class="app-card yellow">
                        <div class="upper">
                            <img src="/img/home/slide-private-label.png"/>
                            <div>WHITE LABEL?</div>
                        </div>
                        <ul>
                            @foreach($privateLabel as $item)
                                <li><i class="material-icons">check_circle</i> {{$item}}</li>
                            @endforeach
                        </ul>
                        <a class="goto-button grey" href="/white-label">MEER INFORMATIE</a>
                    </div>
                </div>


            </div>
            <div class="brd-cp"></div>
            <img class="laptop d-none d-md-block" src="/img/shared/dashboard-new-beheer.png"/>
            <div class="lower">
                <p>
                    VvE beheerders hebben de mogelijkheid om meerdere VvE’s toe te voegen onder één account. Vraag naar de mogelijkheden.
                </p>
                <a class="goto-button" href="/demo">BEKIJK DEMO</a>
            </div>
        </div>
    </section>



@stop
