@extends("layouts.site")

@section("title", "Helpdesk Appartement - Antwoorden op de meest gestelde vragen")
@section("description", "Vind direct antwoorden op de meest gestelde vragen. Appartement biedt snelle en vaardige support aan alle gebruikers.")
@section("keywords", "Helpdesk appartement")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/support.css')}}">
@stop


@section("after_js")
    <script src="{{mix('/js/pages/support.js')}}"></script>


@stop

@php
$device = Request::route('device');
$category = Request::route('category');
$section = Request::route('section');

if(!$device){
    $device = "web";
    $category = "Dashboard";
}
if(!$category){
    $category = $device == "web" ? "Dashboard": null;
}


$navList = [
    "Dashboard",
    "VvE" => [
       "Appartement",
       "Algemene info",
       "Reparatieverzoeken",
      // "Labels (uitgelicht)",
       "Bouwdelen",
       "VvE Beheerder"
    ],
    "Kalender",
    "Bestuursleden",
    "Prikbord",
    "Documenten",
    "Reparatieverzoeken",
    "Huishoudelijk reglement",
    "Nieuwsbrief",
    "Stemmen",
    "Bewoners",
    "Chat"
];

function youtube($id){
    return '<iframe src="https://www.youtube.com/embed/'.$id.'" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
}

@endphp

@section("content")
{{--    <div class="search-wrapper">--}}
{{--        <div class="container">--}}
{{--            <input  placeholder="Zoeken in de documentatie" name="search"/>--}}
{{--        </div>--}}
{{--    </div>--}}
    <div class="tabs-wrapper">
        <h1>Helpdesk</h1>
        <div class="container">
            <div class="tabs">
                <a href="/helpdesk/web" class="{{$device == "web" ? "active" : ""}}"><span><img src="/img/icons/monitor.svg"/></span> Web panel</a>
                <a href="/helpdesk/mobile" class="{{$device == "mobile" ? "active" : ""}}"><span><img src="/img/icons/phone.svg"/></span> iOS, Android</a>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="route">
            <a href="/helpdeskt/{{$device}}">{{$device == "web" ? "Web panel": "iOS, Android"}}</a>
            @if($category) <i class="material-icons">navigate_next</i> <a href="/helpdesk/{{$device}}/{{$category}}">{{$category}}</a> @endif
            @if($section) <i class="material-icons">navigate_next</i> <a>{{$section}}</a> @endif
        </div>
        <div class="main-wrapper">
            @if($device == "web")

                <div class="nav-list">
                    <ul>
                        @foreach($navList as $index => $item)
                            @if(is_array($item))
                                <li class="has-sub {{$category == $index ? "active" : ""}}">
                                    <div><i class="material-icons">navigate_next</i> {{$index}}</div>
                                    <ul>
                                        @foreach($item as $link)
                                            <li><a class="{{$category == $index && $section == $link ? "active" : ""}}"
                                                   href="/helpdesk/{{$device}}/{{$index}}/{{$link}}">{{$link}}</a></li>
                                        @endforeach
                                    </ul>
                                </li>
                            @else
                                <li><a class="{{$item == $category ? "active" : ""}}" href="/helpdesk/{{$device}}/{{$item}}">{{$item}}</a></li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="content">
                @if($device == "web")
                    @if($category == "Dashboard")
                        <h2>Dashboard</h2>
                        <img src="/img/support/dashboard.png" alt="dashboard"/>
                        <h4>Waar dient het dashboard voor?</h4>
                        <p>In het dashboard treft u een overzicht met allerlei handige statistieken zoals het aantal reparatieverzoeken, berichten en nog veel meer. Het dashboard wordt continue uitgebreid met nieuwe handige statistieken. </p>
                    @endif

                    @if($category == "VvE")
                        <h2>VvE</h2>
                        @if($section == "Appartement")
                            {!! youtube("W-yUhBi5AV0")  !!}
                            <h4>Appartement info</h4>
                            <p>Wanneer u links in het menu op ‘VvE’ klikt, treft u basisinformatie aan over het gebouw. Indien uw VvE door een beheerder wordt beheerd, treft u ook informatie over de beheerder aan in dit overzicht. </p>
                            <p>Wanneer u klikt op uw VvE naam, ziet u algemene informatie en de bouwdelen. Klikt u op de naam van de beheerder, dan ziet u de NAW-gegevens en de contactpersonen die werkzaam zijn bij deze beheerder. </p>
                        @endif

                        @if($section == "Algemene info")
                            {!! youtube("_ue4K3S9oGc")  !!}
                            <h4>Algemene info</h4>
                            <p>U treft hier informatie aan over de VvE. Wanneer u een account aanmaakt, dan zijn enkele velden automatisch ingevuld aan de hand van wat u heeft opgegeven tijdens het aanmelden. </p>
                            <p>Wanneer u op <b>‘bewerk’</b> klikt bij algemene informatie, kunt u wijzigingen doorvoeren en/of informatie aanvullen. U kunt hier de VvE naam, totale rechten, omschrijving, adresgegevens, het aantal woningen, parkeerplekken, bergingen etc. opgeven. </p>
                        @endif
                        @if($section == "Reparatieverzoeken")
                            {!! youtube("4k-4XvB-NCg")  !!}
                            <h4>Reparatieverzoeken bij een derde partij</h4>
                            <p>Wanneer deze functie is ingeschakeld, zien gebruikers een melding dat ze geen reparatieverzoeken kunnen doorgeven via de app.
                                Dit komt omdat uw VvE reparatieverzoeken via andere software of methodes verwerkt. Standaard staat deze functie ingeschakeld. Zie voor meer informatie het onderwerp ‘Reparatieverzoeken’.</p>
                        @endif
                        @if($section == "Labels (uitgelicht)")
                            <h4>Labels (uitgelicht)</h4>
                            <p>In deze sectie kunt u een foto van het pand of een logo uploaden. Klik vervolgens op <b>‘klaar’</b> om de wijzigingen op te slaan, of op ‘annuleren’ om de wijzigingen te negeren.</p>
                        @endif
                        @if($section == "Bouwdelen")
                            <h4>Bouwdelen</h4>
                            <p>In het gedeelte ‘bouwdelen’ kunt u indexnummers toevoegen en de juiste verdiepingen toewijzen met de eventueel daarbij behorende subeenheden.
                                Wanneer u een ondergrondse parkeergarage heeft, dan voegt u bijvoorbeeld verdieping -1 toe en wijst u de parkeerplekken aan de indexnummers.
                                Dit doet u net zo lang tot alle verdiepingen en indexnummers gekoppeld zijn aan de juiste ruimtes. Dit geeft uiteindelijk het beste resultaat.</p>
                        @endif
                        @if($section == "VvE Beheerder")
                            <h4>VvE beheerder - Bedrijfsprofiel</h4>
                            <p>Wanneer u op de naam van de beheerder klikt dan ziet u een overzicht van de bedrijfsgegevens van de beheerder. Ook ziet u de contactpersonen en hun functies.
                                U kunt deze informatie alleen inzien en niet bewerken.
                                Heeft u vragen of opmerkingen hierover, of staat uw beheerder niet in de lijst? Neem dan <a href="/contact">contact</a> op.</p>
                        @endif
                    @endif
                    @if($category == "Kalender")
                        <h2>Kalender</h2>
                        <p>De kalender is handig om bestuursleden en leden op de hoogte te brengen en houden van evenementen en gebeurtenissen zoals algemene ledenvergaderingen, gepland onderhoud, borrels, bijeenkomsten en meer. </p>
                        <h4>Evenement aanmaken/wijzigen</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Kalender’</b></li>
                            <li>Klik op een <b>datum</b></li>
                            <li>U ziet een <b>pop-up</b> verschijnen. Indien er nog niets is gecreëerd kunt u gemakkelijk een evenement toevoegen. Heeft u een evenement aangemaakt, dan kunt u deze hier wijzigen.</li>
                            <li>Vul alle details zoals gewenst in bij <b>stap 1</b></li>
                            <li>Bij <b>stap 2</b> kunt u aangeven wie dit evenement kunnen inzien. U kunt er voor kiezen om dit alleen inzichtelijk te maken voor de bestuurders, zodat de leden dit niet kunnen zien.</li>
                            <li>Geef aan of u wilt dat de gekozen groep hier een <b>push notificatie</b> ontvangt en er een bericht op het prikbord wordt geplaatst</li>
                            <li>Als laatste stap kunt u aangeven of u wil dat er een <b>‘deelname’</b> knop wordt toegevoegd. Dit is optioneel en laat een knop zien aan de ontvangers waarbij zij kunnen aangeven of zij deelnemen aan het evenement. </li>
                        </ul>
                    @endif
                    @if($category == "Bestuursleden")
                        <h2>Bestuursleden</h2>
                        <p>In dit gedeelte treft u een lijst aan met de bestuurders van de VvE. U kunt hier zien welke bestuurder welke functie bekleedt in een handig overzicht. Gebruikers van de app zien deze lijst ook terug in de app.</p>
                        <h4>Bestuurslid toevoegen</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Bestuurders’</b></li>
                            <li>Klik op <b>‘Bestuursleden toevoegen’</b> rechtsboven</li>
                            <li>Een <b>nieuwe pagina</b> opent</li>
                            <li>Vul hier alle gegevens in en selecteer de juiste <b>functie</b>. Staat de functie niet in de lijst? Neem dan contact op</li>
                            <li>Nadat alles correct is ingevuld klikt u op <b>‘opslaan’</b></li>
                            <li>Het bestuurslid komt nu in het overzicht te staan. U kunt hier <b>zoeken</b> naar een bestuurslid.
                                Via de <b>tabbladen</b> kunt u selecteren welke bestuursleden vertoond moeten worden.</li>
                            <li>Om informatie te <b>bewerken</b> klikt u op een bestuurder uit het overzicht. U kunt hierna wijzigingen doorvoeren en deze opslaan.</li>
                        </ul>
                    @endif
                    @if($category == "Bewoners")
                        <h2>Bewoners</h2>
                        <p>In dit gedeelte treft u een lijst aan met alle leden van de VvE waaronder bewoners. U kunt hier zien welke leden woningeigenaar of huurder zijn. Ook ziet u hier leden die uitgenodigd zijn om de app te gebruiken en welke gebruikers de app niet zullen gebruiken. Investeerders/bedrijven treft u ook aan in dit overzicht. </p>
                        <h4>Bestuurslid toevoegen</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Bewoners’</b></li>
                            <li>Klik op <b>‘Bewoner toevoegen’</b> rechtsboven</li>
                            <li>Een <b>nieuwe pagina</b> opent</li>
                            <li>Vul hier alle gegevens in en selecteer eventueel de juiste functie indien van toepassing. Staat de functie niet in de lijst? Neem dan contact op</li>
                            <li>Nadat alles correct is ingevuld klikt u op <b>‘opslaan’</b></li>
                            <li>Het lid komt nu in het overzicht te staan. U kunt hier <b>zoeken</b> naar een lid. Via de <b>tabbladen</b> kunt u selecteren welke leden vertoond moeten worden.</li>
                            <li>Om informatie te <b>bewerken</b> klikt u op de een lid uit het overzicht. U kunt hierna wijzigingen doorvoeren en deze opslaan.</li>
                        </ul>
                        <p>
                            <b>LET OP</b>: Voordat u een bewoner toevoegt, dienen er bouwdelen aangemaakt te worden. Er dient namelijk een eenheid toegewezen te worden aan een bewoner.
                            Zonder het aanmaken van bouwdelen is het niet mogelijk om een bewoner toe te voegen.
                        </p>
                        <p>Voor het maken van een bouwdeel, zie ook <a href="/helpdesk/web/VvE/Bouwdelen">VvE - Bouwdelen</a></p>
                    @endif
                    @if($category == "Prikbord")
                        <h2>Prikbord</h2>
                        <p>
                            Het prikbord is een handige functie om berichten te plaatsen. Deze berichten kunnen door het bestuur en leden geplaatst worden.
                            Het is vergelijkbaar met de tijdslijn van social media kanalen zoals Facebook. Wanneer een bericht geplaatst wordt, ontvangen alle gebruikers een <u>push notificatie</u> op hun smartphone.
                            Gebruikers die deze optie hebben uitgeschakeld ontvangen geen melding.
                        </p>
                        <h4>Bericht aanmaken/wijzigen</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Prikbord’</b></li>
                            <li>Klik op <b>‘Nieuw bericht’</b> rechtsboven</li>
                            <li>U ziet een <b>pop-up</b> verschijnen. Maak hier een bericht aan en voeg indien u wenst een bijlage toe door op ‘een bijlage uploaden’ te klikken onderaan. Klik op ‘toevoegen’ </li>
                            <li>Uw bericht is nu <b>geplaatst</b></li>
                            <li>Om een bericht te <b>wijzigen</b> klikt u op het bericht. Er opent een nieuwe pagina. </li>
                            <li>Op de nieuwe pagina klikt u op <b>‘bewerk’</b>. Er opent een pop-up. Volg de stappen hierboven om de wijzigingen toe te voegen en op te slaan.</li>
                        </ul>
                        <h4>Opmerking plaatsen en liken</h4>
                        <ul>
                            <li>Klik op een <b>bericht</b> in het overzicht. Er opent een nieuwe pagina. </li>
                            <li>Op de nieuwe pagina ziet u het bericht. U kunt hier een opmerking plaatsen onder het bericht</li>
                            <li>Om het bericht te ‘liken’ klikt u op <b>‘like’</b> onder het bericht</li>
                        </ul>
                        <h4>Bericht verwijderen</h4>
                        <ul>
                            <li>Klik op een bericht in het overzicht. Er opent een nieuwe pagina. </li>
                            <li>Op de nieuwe pagina ziet u het bericht. U kunt het bericht verwijderen door op <b>‘verwijderen’</b> rechtsboven te klikken</li>
                        </ul>
                    @endif
                    @if($category == "Documenten")
                        <p>In het gedeelte ‘documenten’ kunt u allerlei documenten uploaden die zichtbaar worden in de app. Ook kunt u documenten alleen inzichtelijk maken voor het bestuur, zodat leden deze niet te zien krijgen.</p>
                        <h4>Document uploaden</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Documenten’</b></li>
                            <li>Klik op <b>‘Document toevoegen’</b> rechtsboven</li>
                            <li>U ziet een pop-up verschijnen. Voeg het document toe door op <b>‘een bijlage uploaden’</b> te klikken. </li>
                            <li>Geef het document een <b>titel</b></li>
                            <li>Wijs een <b>categorie</b> aan</li>
                            <li>Geef aan voor wie het document <b>zichtbaar</b> moet zijn</li>
                            <li>Klik op <b>‘verzenden’</b></li>
                            <li>Het document komt nu in het overzicht te staan</li>
                            <li>Alle leden ontvangen een push notificatie</li>
                            <li>U kunt het zoekvenster gebruiken om te zoeken naar een document</li>
                        </ul>
                        <h4>Document bewerken/verwijderen</h4>
                        <ul>
                            <li>Zoek het gewenste document en klik op het <b>‘potloodje’</b> om te <b>bewerken</b></li>
                            <li>Klik op het <b>‘prullenbak’ icoontje</b> om het document te verwijderen.
                                <b> Let op: bij het verwijderen gaan de documenten permanent verloren.</b></li>
                        </ul>
                    @endif
                    @if($category == "Reparatieverzoeken")
                        <h2>Reparatieverzoeken</h2>
                        <p>Bij ‘Reparatieverzoeken’ ziet u een overzicht van alle gemelde reparatieverzoeken.
                            Een reparatieverzoek kan <b>alleen via de Appartement App</b> aangemaakt worden door leden en bestuurders.
                            In de portaal kan een reparatieverzoek beheerd worden door het bestuur.</p>
                        <h4>Reparatieverzoek beheren</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Reparatieverzoeken’</b></li>
                            <li>U kunt <b>filteren</b> op <b>categorie</b>, <b>datum en status</b></li>
                            <li>Klik op een <b>reparatieverzoek</b></li>
                            <li>Een <b>nieuwe pagina</b> opent</li>
                            <li>U kunt hier de <b>status bekijken, opmerkingen plaatsen</b> en bekijken, <b>liken, verwijderen</b> en de <b>status wijzigen</b></li>
                        </ul>
                    @endif
                    @if($category == "Huishoudelijk reglement")
                        <h2>Huishoudelijk reglement</h2>
                        <p>In het gedeelte ‘Huishoudelijk reglement’ kunt u het huishoudelijk reglement van uw VvE toevoegen.
                            Deze wordt op een handige wijze weergegeven in de app. Gebruikers kunnen ook zoeken naar bepaalde onderwerpen.
                            Op deze wijze hoeft een gebruiker niet het gehele document door te nemen, indien er gezocht wordt naar een specifiek onderwerp.</p>
                        <h4>Huishoudelijk reglement toevoegen</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Huishoudelijk reglement’</b></li>
                            <li>Klik op <b>‘toevoegen’</b> rechts bovenaan</li>
                            <li>Een <b>pop-up</b> opent</li>
                            <li>U kunt kiezen uit een <b>type bericht</b>. Kies voor <b>‘algemeen’</b> wanneer dit een introductie tekst is bijvoorbeeld.
                                Kies voor <b>‘reglement’</b> wanneer dit een tekst uit het reglement is.</li>
                            <li>Wanneer u de optie <b>‘belangrijk’</b> aanvinkt, verschijnt er een icoontje om onderscheid te maken tussen ‘normale’ gedeelten en ‘belangrijke’ gedeelten. U kunt deze functie alleen aanvinken wanneer het gaat om een ‘reglement’ type.</li>
                            <li>Geef een <b>titel</b> en <b>inhoud</b> op. U ziet ook <b>‘sorteren’</b> staan. DIt heeft te maken met de volgorde van het gedeelte. Wilt u het bovenaan plaatsen, dan vult u bijvoorbeeld ‘1’ in.</li>
                            <li>Klik op <b>‘Klaar’</b> om de sectie toe te voegen. Doe dit net zo lang tot alle gedeelten toegevoegd zijn</li>
                            <li>Wanneer u rechtsboven op <b>‘Voorbeeld’</b> klikt, ziet u een voorbeeldweergave van een smartphone. Op deze wijze heeft u een indruk hoe dit eruit ziet voor de gebruiker in de app.</li>
                        </ul>
                    @endif
                    @if($category == "Nieuwsbrief")
                        <h2>Nieuws</h2>
                        <p>In het gedeelte ‘Nieuws’ kunt u nieuwsberichten aanmaken. Deze komen in de app onder ‘Nieuws’ te staan. Nieuwsberichten zijn handig wanneer u periodiek nieuws hebt over het gebouw, de omgeving, de leden, het bestuur en nog veel meer.</p>
                        <h4>Nieuwsbericht toevoegen</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Nieuws’</b></li>
                            <li>Klik op <b>‘maak nieuwsbrief’</b> rechts bovenaan</li>
                            <li>Een <b>nieuwe pagina</b> opent</li>
                            <li>Geef een <b>titel</b> en <b>omschrijving</b> op</li>
                            <li>In het gedeelte eronder kunt u uw gewenste inhoud typen en bewerken.
                                U kunt berichten bewerken zoals u gewend bent met deze meeste tekstverwerkings software</li>
                            <li>Wanneer u rechtsboven op <b>‘Voorbeeld’</b> klikt, ziet u een voorbeeldweergave van een smartphone. Op deze wijze heeft u een indruk hoe dit eruit ziet voor de gebruiker in de app.</li>
                            <li>Klik op <b>‘opslaan’</b> en uw bericht wordt geplaatst.</li>
                            <li>In het overzicht vindt u alle geplaatste berichten. Het meest recente bericht staat bovenaan. U kunt door middel van de <b>zoekfunctie</b> zoeken naar een specifiek bericht.</li>
                        </ul>
                    @endif
                    @if($category == "Stemmen")
                        <h2>Stemmen</h2>
                        <p>In het gedeelte ‘Stemmen’ kunt u stemmingen aanmaken en deze geheel naar wens inrichten. Wanneer een stemming is aangemaakt, ontvangen alle gebruikers een push notificatie.</p>
                        <h4>Stemming toevoegen</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Stemmen’</b></li>
                            <li>Klik op <b>‘toevoegen’</b> rechts bovenaan</li>
                            <li>Een <b>nieuwe pagina</b> opent</li>
                            <li>Geef bij <b>instellingen</b> aan op welke basis de stemming aangemaakt moet worden.
                                Ook kunt u hier een <b>kiesdrempel</b> opgeven en een <b>minimale percentage</b> instellen om de stemming geldig te verklaren. </li>
                            <li>Bij <b>‘machtiging’</b> kunt u bestuursleden van de VvE of beheerders selecteren, die in een lijst verschijnen wanneer een lid via een machtiging wenst te stemmen.</li>
                            <li>Vul bij <b>‘stemgegevens’</b> de titel en beschrijving in en geef aan wanneer de stemming zal plaatsvinden en wanneer deze zal sluiten. Eventueel kunt u hier ook nog een bijlage toevoegen.</li>
                            <li>Geef hierna de <b>‘opties’</b> waaruit de leden kunnen kiezen tijdens het stemmen</li>
                            <li>Wanneer u op <b>‘opslaan’</b> klikt dan wordt de stemming aangemaakt en ontvangt iedereen een push notificatie hiervan mits deze optie ingeschakeld is.</li>
                            <li>In het overzicht vindt u alle stemmingen. De datum en status staan hier vermeld.
                                Ook kunt u de stemming <b>annuleren</b>. U kunt verder door middel van de <b>zoekfunctie</b> of <b>per datum</b> en <b>status</b> zoeken naar een specifieke stemming.</li>
                        </ul>
                        <h4>Stemmings resultaten</h4>
                        <ul>
                            <li>U ziet een overzicht van de resultaten bij het kopje <b>‘resultaat’</b>.
                                Wanneer de stemming de einddatum- en tijd heeft bereikt ziet u bij <b>‘uitkomsten’</b> een knop verschijnen met <b>‘bevestigen’</b>.</li>
                            <li>Onderaan kunt u zien op welke wijze en wat er is <b>gestemd door de leden</b></li>
                        </ul>
                        <h4>Statussen</h4>
                        <p>Er zijn <b>4 verschillende statussen</b>. Bekijk hieronder uitleg hierover.</p>
                        <ul>
                            <li><b>Status 1: actief.</b> Deze status geeft aan dat er een stemming is aangemaakt en de leden kunnen stemmen tot het opgegeven einddatum- en tijd.</li>
                            <li><b>Status 2: telling:</b> Deze status geeft aan dat de stemming is gesloten.
                                Eén van de bestuursleden dient de telling te <b>bevestigen</b> om het resultaat definitief te maken.
                                <b>Let op:</b> Er kan alleen bevestigd worden wanneer alle machtigingen zijn geaccepteerd.</li>
                            <li><b>Status 3: gesloten.</b> Deze status geeft aan dat de stemming succesvol is bevestigd en het resultaat bekend is. Het resultaat kan bekeken worden bij het kopje <b>‘uitkomsten’</b></li>
                            <li><b>Status 4: geannuleerd:</b> Deze status geeft aan dat de stemming is geannuleerd. Leden kunnen niet meer stemmen en alle stemmen worden nietig verklaard. Ook kan de stemming verwijderd worden.</li>
                        </ul>
                    @endif
                    @if($category == "Chat")
                        <h2>Chat</h2>
                        <p>Met de functie ‘chat’ kunnen bewoners en bestuursleden berichten naar elkaar sturen. Bestuurders kunnen groepen aanmaken en bestuursleden toevoegen. Dit is vooral handig omdat er per thema aparte groepen aangemaakt kunnen worden. Bewoners kunnen niet onderling met elkaar chatten. </p>
                        <h4>Chat starten</h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Chat’</b></li>
                            <li>Klik op <b>‘Begin chat’</b> rechts bovenaan</li>
                            <li>Een <b>pop-up</b> opent. Kies een persoon om een bericht naar te sturen</li>
                            <li>De chat is nu aangemaakt</li>
                        </ul>
                        <h4>Groepschat </h4>
                        <ul>
                            <li>Klik in het menu aan de linkerkant op <b>‘Chat’</b></li>
                            <li>Klik op <b>‘Begin groepschat’</b> rechts bovenaan</li>
                            <li>Een <b>pop-up</b> opent. Kies de deelnemers en geef de groep een naam en omschrijving en klik op <b>toevoegen</b></li>
                            <li>De chat is nu aangemaakt</li>
                        </ul>
                    @endif
                @endif
            </div>
        </div>
        @if($device == "mobile")
            <div class="coming-soon">
                <div>
                    <img src="/img/coming-soon.png" style="max-width: 100%"/>
                </div>
                Coming soon
            </div>
        @endif

    </div>



@endsection
