
@extends("layouts.site")

@section("title", "Bedankt")

@section("after_css")
    <link rel="stylesheet" href="{{mix('/css/pages/contact.css')}}">
    <link rel="stylesheet" href="{{mix('/css/pages/bedankt.css')}}">
@stop

@php

$type = request()->get("result");

@endphp

@section("content")

    <section>
        <div class="box-orange box-blue">
            <img class="mob-size" src="/img/shared/clouds-white.svg" alt="">
            <img class="bulding-svg" src="/img/shared/city-white.svg" alt="">
            <div class="txt-contact">
                <h1 class="single">
                    @if($type == "goes-to-create" || !$type)
                        Bedankt, uw e-mailadres is succesvol geverifieerd!
                    @endif
                    @if($type == "expire-token")
                        Error...
                    @endif
                    @if($type == "error-reported")
                        We zijn bijna zover!
                    @endif
                    @if($type == "reconfirm-token")
                        Verificatie
                    @endif
                </h1>
            </div>
            <img class="mob-size-city" src="/img/shared/buildings-white.svg" alt="">
        </div>
        <div class="container">
            <div class="tabs-pri">
                <div class="cont-form">
                    @if($type == "goes-to-create" || !$type)
                    <h2><img class="img-check" src="/img/Group 16009.png" alt=""> Succesvol geverifieerd!</h2>
                    <p>
                        Uw '30 dagen trial' account wordt voor u aangemaakt. Uw inloggegevens voor de VvE portaal worden binnen uiterlijk 1 uur per e-mail toegestuurd.
                        <br/><br/>
                        U kunt nu de app downloaden en inloggen met het nummer:<br/>
                        +{{request()->get("phone")}}
                        <br/>
                        @component("components.store-links")
                            @slot("hideAvg", true)
                        @endcomponent
                        <br/><br/>
                        Veel succes met de trial.
                    </p>
                    @endif
                    @if($type == "expire-token")
                        <h2 style="color: #d40000"><img class="img-check" src="/img/icons/close-circle.png" alt="" style="margin-right: 4px">  Verificatie verlopen!</h2>
                        <p>
                            Maakt u zich geen zorgen, we sturen u een nieuwe verificatie e-mail. Controleer uw e-mail.
                        </p>
                    @endif
                    @if($type == "error-reported")
                        <h2 style="color: #d40000"><img class="img-check" src="/img/icons/close-circle.png" alt="" style="margin-right: 4px">Er is een klein probleempje!</h2>
                        <p>
                            Het is om technische redenen niet gelukt uw '30 dagen trial' account aan te maken.
                            Dit probleem is gerapporteerd aan de technische dienst.  Uw inloggegevens worden binnen uiterlijk 24 uur per e-mail toegestuurd.
                            <br/><br/>
                            Onze excuses voor het ongemak!
                        </p>
                    @endif
                    @if($type == "reconfirm-token")
                        <h2 style="color: #d40000"><img class="img-check" src="/img/icons/close-circle.png" alt="" style="margin-right: 4px">Verificatie reeds uitgevoerd!</h2>
                        <p>
                            Het ziet er naar uit dat de verificatie al uitgevoerd is.
                        </p>
                    @endif
                    <a href="/" class="bedankt-btn"><img src="/img/icons/Icon-awesome-arrow-alt-circle-right.png" alt=""> TERUG NAAR HOME</a>
                </div>
            </div>
        </div>

    </section>
    <section class="info">
        <div class="container">
            <div class="middl-content">
                <div class="row">
                    <div class="col-md-4">
                        <div class="middl-txt">
                            <img src="/img/icons/building-circular.png" alt="">
                            <div>Bezoekadres</div>
                            <ul>
                                <li><h3>Appartement App</h3></li>
                                <li><p>Onderdeel van WhiteBoard Studio B.V.</p></li>
                                <li><p>Poort van Uden</p></li>
                                <li><p>Rondweg 55</p></li>
                                <li><p>5406 NK Uden</p></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="middl-txt box-txt">
                            <img src="/img/icons/message-circular.png" alt="">
                            <div> Contact</div>
                            <ul>
                                <li><p>info@app-artement.nl</p></li>
                                <li><p>www.app-artement.nl</p></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="middl-txt ">
                            <img src="/img/icons/briefcase-circular.png" alt="">
                            <div> Zakelijk</div>
                            <ul>
                                <li><p>KvK: 67189334</p></li>
                                <li><p>BTW: NL856867858B01</p></li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
@stop
