@extends("layouts.site")

@section("title", "Test de VvE app 30 dagen vrijblijvend via de trial. Geef aan welk pakket het beste bij uw organisatie past en u kunt aan de slag.")
@section("description", "De trial geeft u de mogelijkheid om de Appartement VvE app geheel vrijblijvend te testen. Bespaar veel handelingen, kosten en frustraties en stap over naar een modern alternatief.")
@section("keywords", "VvE App Trial")

@section("after_css")
    <link rel="stylesheet" href="/css/swiper.css"/>
    <link rel="stylesheet" href="{{mix('/css/pages/prijzen.css')}}"/>
    <style>
        .swiper-button-prev, .swiper-button-next {
            top: 222px
        }
    </style>
@stop

@php
    $data = [
              "title" => "VvE bestuurders",
              "subTitle" => "Bekijk de prijzen voor Vve bestuurders:",
              "parts" => [
                  [
                      "name" => "Standaard",
                      "price" => "Op aanvraag",
                      "ideal" => "VvE’s die genoeg hebben aan het instappakket.",
                      "features" => 4
                  ],
                  [
                      "name" => "Professional",
                      "price" => "Op aanvraag",
                      "ideal" => "VvE’s die de meest voorkomende problemen willen oplossen.",
                      "features" => 15
                  ],
                  [
                      "name" => "Premium",
                      "price" => "Op aanvraag",
                      "ideal" => "VvE’s die het maximale uit de app willen halen.",
                      "features" => 21
                  ]
              ]
          ];
          $features = [
              "Prikbord", "Kalender", "Ledenlijst", "bestuurderslijst", "Logboek", "Pushberichten", "VvE documenten", "VvE beheerder informatie", "Rollenverdeling (Bestuur, bewoner, beheerder)",
              "VvE panel (web app)", "PDF aanmaken voor niet app gebruikers", "Chatfunctie (berichten)", "Multi language (NL/EN)", "Reparatieverzoeken inclusief status wijzigingen",
              "Huishoudelijk reglement", "Huurders functie", "Nieuwsbrief", "Stemmen via de app", "MJOP", "Planning", "Projecten"
          ];
@endphp

@section("after_js")
    <script src="/js/swiper.min.js"></script>

    <script>

        var tabButtons = document.querySelectorAll(".tabs button");



        var config = {
            slidesPerView: 1,
            spaceBetween: 20,
            centeredSlides: true,
            initialSlide: 1,
            breakpoints: {
                576: {
                    slidesPerView: 2,
                    spaceBetween: 30,
                }
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
        };

        function activateTab(num){

            var toActive =  document.querySelector("div.tab-data:nth-of-type(" + num + ")");
            toActive.classList.add("active");

            var swiper = toActive.querySelector(".swiper-container");
            if(swiper)
                new Swiper(swiper, config)
        }

        activateTab(1);

        for (var i = 0; i < tabButtons.length; i++) {

            tabButtons[i].addEventListener("click", function () {
                document.querySelector(".tabs button.active").classList.remove("active");
                this.classList.add("active");
                document.querySelector(".tab-data.active").classList.remove("active");

                activateTab(this.getAttribute("data-active"))
            })
        }


        // var swiper = new Swiper('.swipe-1', config);
        // var swiper2 = new Swiper('.swipe-2', config);


    </script>
@stop

@section("content")

    <section>
        <div class="box-orange">
            <img class="mob-size" src="/img/shared/clouds-white.svg" alt="">
            <img class="bulding-svg" src="/img/shared/city-white.svg" alt="">
            <img class="mob-size-city" src="/img/shared/buildings-white.svg" alt="">
            <div>
                <div class="container">
                    <div class="txt-prij">
                        <h1>Trial</h1>
                        <p>30 dagen trial</p>
                    </div>
                </div>
                <div class="container tabs-container">
                    <div class="tabs">
                        <button data-active="1" class="active"> VvE bestuurders</button>
                        <button data-active="2"> VvE beheerders</button>
                        <button data-active="3"> Enterprise</button>
                    </div>
                </div>
            </div>
        </div>


        <div class="prij-one">
            <div class="tabs-pri tab-data active">
                <div class="w3-container city">
                    <div class="container">
                        <div class="txt-prij-two">
                            <h2>VvE bestuurders</h2>
                            <p>Test de app 30 dagen geheel vrijblijvend. Geef hieronder aan welk pakket het beste bij uw organisatie past. Meld u daarna éénvoudig aan.</p>
                        </div>
                        <div class="row cards-desktop">
                            @foreach($data["parts"] as $part)
                                <div class="col-md-4">
                                    <div class="price-card">
                                        <div class="upper">
                                            <img src="img/icons/apartment-people.svg" alt="">
                                            <div class="name">{{$part["name"]}}</div>
                                            <div class="price">{{$part["price"]}}</div>
                                        </div>
                                        <a class="simple-button" href="/30-day-trial">30 DAGEN TRIAL AANVRAGEN</a>
                                        <div class="ideal">
                                            <div>IDEAAL VOOR:</div>
                                            <p>{{$part["ideal"]}}</p>
                                        </div>
                                        <div class="features-title">Dit pakket bevat:</div>
                                        <ul>
                                            @foreach($features as $feature)
                                                <li class="{{$loop->iteration > $part["features"] ? "grey" : ""}}"><i class="material-icons">check</i> {{$feature}}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>

                    <div class="cards-mobile">

                        <div class="swiper-container swipe-1">
                            <div class="swiper-pagination swiper-pagination-top"></div>
                            <div class="swiper-wrapper">
                                @foreach($data["parts"] as $part)
                                    <div class="swiper-slide">

                                        <div class="price-card">
                                            <div class="upper">
                                                <img src="img/icons/apartment-people.svg" alt="">
                                                <div class="name">{{$part["name"]}}</div>
                                                <div class="price">{{$part["price"]}}</div>
                                            </div>
                                            <a class="simple-button" href="/30-day-trial">30 DAGEN TRIAL AANVRAGEN</a>
                                            <div class="ideal">
                                                <div>IDEAAL VOOR:</div>
                                                <p>{{$part["ideal"]}}</p>
                                            </div>
                                            <div class="features-title">Dit pakket bevat:</div>
                                            <ul>
                                                @foreach($features as $feature)
                                                    <li class="{{$loop->iteration > $part["features"] ? "grey" : ""}}"><i class="material-icons">check</i> {{$feature}}</li>
                                                @endforeach
                                            </ul>
                                        </div>

                                    </div>
                                @endforeach
                            </div>

                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>

                        </div>

                    </div>
                </div>
            </div>

            <div class="tabs-pri tab-data">
                <div class="coming-soon">
                    <div>
                        <img src="/img/coming-soon.png" style="max-width: 100%"/>
                    </div>
                    Coming soon
                </div>

                {{--                    <div class="w3-container city">--}}
                {{--                        <div class="container">--}}
                {{--                            <div class="txt-prij-two">--}}
                {{--                                <h2>VvE beheerders</h2>--}}
                {{--                                <p>Bekijk de prijzen voor VvE beheerders:</p>--}}
                {{--                            </div>--}}

                {{--                            <div class="row cards-desktop">--}}
                {{--                                @foreach($data["parts"] as $part)--}}
                {{--                                    <div class="col-md-4">--}}
                {{--                                        <div class="price-card">--}}
                {{--                                            <div class="upper">--}}
                {{--                                                <img src="img/icons/apartment-people.svg" alt="">--}}
                {{--                                                <div class="name">{{$part["name"]}}</div>--}}
                {{--                                                <div class="price">{{$part["price"]}}</div>--}}
                {{--                                            </div>--}}
                {{--                                            <a class="simple-button" href="/contact#trial">30 DAGEN TRIAL AANVRAGEN</a>--}}
                {{--                                            <div class="ideal">--}}
                {{--                                                <div>IDEAAL VOOR:</div>--}}
                {{--                                                <p>{{$part["ideal"]}}</p>--}}
                {{--                                            </div>--}}
                {{--                                            <div class="features-title">Dit pakket bevat:</div>--}}
                {{--                                            <ul>--}}
                {{--                                                @foreach($features as $feature)--}}
                {{--                                                    <li class="{{$loop->iteration > $part["features"] ? "grey" : ""}}"><i class="material-icons">check</i> {{$feature}}</li>--}}
                {{--                                                @endforeach--}}
                {{--                                            </ul>--}}
                {{--                                        </div>--}}
                {{--                                    </div>--}}
                {{--                                @endforeach--}}

                {{--                            </div>--}}

                {{--                        </div>--}}
                {{--                        <div class="cards-mobile">--}}

                {{--                            <div class="swiper-container swipe-2">--}}
                {{--                                <div class="swiper-pagination swiper-pagination-top"></div>--}}
                {{--                                <div class="swiper-wrapper">--}}
                {{--                                    @foreach($data["parts"] as $part)--}}

                {{--                                        <div class="swiper-slide">--}}
                {{--                                            <div class="price-card">--}}
                {{--                                                <div class="upper">--}}
                {{--                                                    <img src="img/icons/apartment-people.svg" alt="">--}}
                {{--                                                    <div class="name">{{$part["name"]}}</div>--}}
                {{--                                                    <div class="price">{{$part["price"]}}</div>--}}
                {{--                                                </div>--}}
                {{--                                                <a class="simple-button" href="/contact#trial">30 DAGEN TRIAL AANVRAGEN</a>--}}
                {{--                                                <div class="ideal">--}}
                {{--                                                    <div>IDEAAL VOOR:</div>--}}
                {{--                                                    <p>{{$part["ideal"]}}</p>--}}
                {{--                                                </div>--}}
                {{--                                                <div class="features-title">Dit pakket bevat:</div>--}}
                {{--                                                <ul>--}}
                {{--                                                    @foreach($features as $feature)--}}
                {{--                                                        <li class="{{$loop->iteration > $part["features"] ? "grey" : ""}}"><i class="material-icons">check</i> {{$feature}}</li>--}}
                {{--                                                    @endforeach--}}
                {{--                                                </ul>--}}
                {{--                                            </div>--}}
                {{--                                        </div>--}}

                {{--                                    @endforeach--}}
                {{--                                </div>--}}

                {{--                                <div class="swiper-button-next"></div>--}}
                {{--                                <div class="swiper-button-prev"></div>--}}
                {{--                            </div>--}}



                {{--                        </div>--}}
                {{--                    </div>--}}
            </div>

            <div class="tab-data">
                <div class="coming-soon">
                    <div>
                        <img src="/img/coming-soon.png" style="max-width: 100%"/>
                    </div>
                    Coming soon
                </div>
            </div>

        </div>

    </section>
@stop
